# ------------------------------------------------------------------------------
# DigDagViz project configuration file
#
# Started 2010/05/07 by Anthony Nemoff
# Last update 2010/07/18 by Anthony Nemoff
# ------------------------------------------------------------------------------
# * Project is divided in subfolders :
#   - gui : graphical user interface code and forms
#   - logic : main application logic code
#
# Each subfolder contains a .pri file describing its content, like a .pro file.
# File paths in .pri files are relative to the root project folder.
#
# * Important files :
#   - main.cpp : application entry point
#   - Common.hpp : common project includes
#
# * Includes and librairies :
#   - Paths are system depend for compilation. Change paths depending on your
#   Graphviz installation path.
#
# * Temporary files and folders :
#   - tmp/uics : uic_* files
#   - tmp/mocs : moc_* files
#   - tmp/objs : *.o files
# ------------------------------------------------------------------------------

# Application name (binary executable)
TARGET = DigDagViz

# Project template
TEMPLATE = app


# Source and header files
include( logic/logic.pri )
include( gui/gui.pri )
SOURCES += main.cpp
HEADERS += Common.hpp

# Ressources
RESOURCES += ressources/images.qrc

# Unix includes paths & libs
unix {
  INCLUDEPATH += /usr/include/graphviz

  LIBS += -lgvc \
    -lgraph \
    -lpathplan \
    -lcdt
}

# Windows includes paths & libs
win32 {
  INCLUDEPATH += f:/Programs/Graphviz2.26.3/include/graphviz

  LIBS += f:/Programs/Graphviz2.26.3/lib/release/lib/gvc.lib \
    f:/Programs/Graphviz2.26.3/lib/release/lib/graph.lib \
    f:/Programs/Graphviz2.26.3/lib/release/lib/pathplan.lib \
    f:/Programs/Graphviz2.26.3/lib/release/lib/cdt.lib
}

# Temp objects
UI_DIR = tmp/uics
MOC_DIR = tmp/mocs
OBJECTS_DIR = tmp/objs

