#ifndef CURRENTDAGDOCK_HPP
#define CURRENTDAGDOCK_HPP

#include <QtGui>
#include "../Common.hpp"
#include "../logic/DigDagData.hpp"

// Forward declaration
class MainWindow;

namespace Ui {
  class CurrentDagDock;
}

class CurrentDagDock : public QDockWidget {

  Q_OBJECT

public:

  // Constructor
  explicit CurrentDagDock(MainWindow *parent = 0);

  // Destructor
  ~CurrentDagDock();


  // Getters & setters

  void setDigDagData(DigDagData* digDagData);


  // Methods

  void showDagPattern(int index);

  //void showInputDag(int index);


private slots:

  void showTidList();


private:

  // Private methods
  void connectSlots();

  void setupModelsAndViews();

  void updateDagPatternProperties();

  void clearTidList();

  void updateTidListStatusLabel(bool show, QString message = "");


  // Members
  MainWindow* _mainWindow;
  Ui::CurrentDagDock *_ui;
  DigDagData* _digDagData;

  // Pattern properties model/view
  int currentPatternIndex;
  QStandardItemModel* _patternModel;

  // TID list model/view
  QStandardItemModel*_tidListModel;
  QItemSelectionModel* _tidListSelectionModel;
  QItemSelection _tidListItemSelection;
  QPersistentModelIndex _tidListModelIndex;
  bool _tidListModelIsComplete;


};

#endif // CURRENTDAGDOCK_HPP
