#ifndef EXPLORERDOCK_HPP
#define EXPLORERDOCK_HPP

#include "../Common.hpp"
#include "../logic/DigDagData.hpp"
#include <QtGui>

// Forward declarations
class MainWindow;

namespace Ui {
  class ExplorerDock;
}

/**
 * This class represents the Explorer dock displayed on the left side of
 * DigDagViz main window. It displays the DigDagFile content and allows to explore
 * it contents through many GUI elements.
 */
class ExplorerDock : public QDockWidget {
  Q_OBJECT

public:

  // Constructor & destructor

  explicit ExplorerDock(MainWindow *parent = 0);

  ~ExplorerDock();


  // Getters & setters

  void setDigDagData(DigDagData *data);

  int getCurrentDagPatternIndex();


  // Methods


public slots:

  void selectFirstDagPattern();

  void selectLastDagPattern();

  void selectPreviousDagPattern();

  void selectNextDagPattern();

  void selectDagPattern(int index);


private:

  // Methods
  void connectSlots();

  void setupModelsAndViews();

  void updateFileProperties();

  void selectItemAtRow(QStandardItemModel *model,
                       QItemSelectionModel *selectionModel,
                       QItemSelection &itemSelection,
                       QPersistentModelIndex &modelIndex,
                       int row);

  // Variables
  MainWindow* _mainWindow;
  DigDagData* _digDagData;

  // GUI elements
  Ui::ExplorerDock *_ui;

  // DAG patterns model/view
  QStandardItemModel* _patternsModel;
  QSortFilterProxyModel* _patternsProxyModel;
  QItemSelectionModel* _patternsSelectionModel;
  QItemSelection _patternsItemSelection;
  QPersistentModelIndex _currentPatternModelIndex;

  // Input DAGs model/view
  QStandardItemModel* _inputsModel;
  QSortFilterProxyModel* _inputsProxyModel;
  QItemSelectionModel* _inputsSelectionModel;
  QItemSelection _inputsItemSelection;
  QPersistentModelIndex _currentInputModelIndex;

  // File properties model/view
  QStandardItemModel* _filePropertiesModel;

  // TODO interface with mainwindow ??

private slots:

  void changeCurrentDagPatternItem(const QModelIndex &current, const QModelIndex &previous);

  void changeCurrentInputDagItem(const QModelIndex &current, const QModelIndex &previous);



  /* TODO indexation
    interface de filtrage :
    boite de saisie : _ui->searchPatternTextEdit->text()
    bouton : _ui->searchButton
        connecter le signal "clicked" à une fonction (slot) qui va faire le traitement de recherche
    liste déroulante : _ui->syntaxCombo.index

    */

  // TODO indexation : la fonction de recherche
  void search();


};

#endif // EXPLORERDOCK_HPP
