#include <QtGui>

#include "GraphicDag.hpp"

//////////////////////////////////////////////////////////////////////////////
// CONSTRUCTORS & DESTRUCTOR

/**
 * Constructor
 *
 * @parem _model
 * @param parent
 */
GraphicDag::GraphicDag(DagStructure* _model, QGraphicsItem * parent) :
    QGraphicsItem(parent),
    model(_model),
    objectBuilt(false),
    boundingBox(0, 0, 0, 0),
    RESOLUTION(72)
{

}


/**
 * Destructor
 */
GraphicDag::~GraphicDag() {

  for (int i = 0; i < nodesItemsList.size(); i++)
    delete nodesItemsList.takeAt(i);

  for (int i = 0; i < edgesItemsList.size(); i++)
    delete edgesItemsList.takeAt(i);

}


//////////////////////////////////////////////////////////////////////////////
// METHODS


QRectF GraphicDag::boundingRect() const {

  return boundingBox;

}


void GraphicDag::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget) {

  Q_UNUSED(painter);
  Q_UNUSED(option);
  Q_UNUSED(widget);

  // DEBUG axis & bound rect
  /*painter->setPen(QPen(Qt::green));
  // X
  painter->drawLine(-3, 0, 300, 0);
  painter->drawLine(-3, 100, 3, 100);
  painter->drawLine(-3, 200, 3, 200);
  // Y
  painter->drawLine(0, -3, 0, 300);
  painter->drawLine(100, -3, 100, 3);
  painter->drawLine(200, -3, 200, 3);*/

  /*painter->setPen(Qt::magenta);
  painter->drawRect(boundingRect());*/

}


void GraphicDag::build() {

  if (objectBuilt)
    return;

  Agnode_t* np;
  Agedge_t* ep;

  // XXX
  //char* attr = agget(model->getGraph(), "dpi");
  //qDebug() << "Resolution :" << QString(attr);


  // --- Bounding box
  // TODO adjust bounding rect to include DAGName text item
  Agraph_t* gp = model->getGraph();
  // width = uper_right.x - lower_left.x
  qreal width = gp->u.bb.UR.x - gp->u.bb.LL.x;
  // height = uper_right.y - lower_left.y
  qreal height = gp->u.bb.UR.y - gp->u.bb.LL.y;
  //boundingBox.setRect(gp->u.bb.LL.x, - gp->u.bb.UR.y, width, height);
  boundingBox.setRect(0, 0, width, height);


  // --- Graph name
  DagName.setParentItem(this);
  // TODO change name if input or pattern
  DagName.setText(model->getGraphName());
  DagName.setFont(QFont(QString(DDV_GVFONT), 10));
  // TODO set DAGName font, size, color ...
  DagName.setPos(this->boundingRect().width()/2 - DagName.boundingRect().width() / 2,
                 - this->boundingRect().height() - 2 * DagName.boundingRect().height());


  // --- Nodes
  for (int i = 0; i < model->getNumberOfNodes(); i++) {

    // Get node pointer
    np = model->getGVNodeAt(i);
    // Create node graphic item
    GraphicNode* nodeItem = new GraphicNode(np, RESOLUTION, this);
    // Add text object to labels list
    nodesItemsList.append(nodeItem);

  } // end nodes for


  // --- Edges
  for (int i = 0; i < model->getNumberOfEdges(); i++) {

    // Get edge pointer
    ep = model->getGVEdgeAt(i);
    // Create edge graphic item
    GraphicEdge* edgeItem = new GraphicEdge(ep, this);
    // Append edge item to the list
    edgesItemsList.append(edgeItem);

  } // end edges for


  // Move child items into positive coordinates
  for (int i = 0; i < childItems().size(); i++) {
    childItems()[i]->moveBy(0, boundingBox.height());
  }


  // Graphic objects are built
  objectBuilt = true;

}

