#ifndef GRAPHICDAG_HPP
#define GRAPHICDAG_HPP

#include "../Common.hpp"
#include "../logic/DagStructure.hpp"
#include "GraphicEdge.hpp"
#include "GraphicNode.hpp"

#include <QtGui>


class GraphicDag : public QGraphicsItem
{

public:

  //////////////////////////////////////////////////////////////////////////////
  // CONSTRUCTORS & DESTRUCTOR

  GraphicDag(DagStructure* model, QGraphicsItem * parent = 0);

  ~GraphicDag();


  //////////////////////////////////////////////////////////////////////////////
  // METHODS

  /**
   * @reimp
   */
  QRectF boundingRect() const;

  /**
   * @reimp
   */
  void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,QWidget *widget);

  void build();


private:

  //////////////////////////////////////////////////////////////////////////////
  // VARIABLES

  DagStructure* model;
  bool objectBuilt;
  QGraphicsSimpleTextItem DagName; /**< DAG Name */
  QList<GraphicNode*> nodesItemsList; /**< Graphic nodes items list */
  QList<GraphicEdge *> edgesItemsList; /**< Graphic edges items list */
  QRectF boundingBox;

  const double RESOLUTION; /**< Graphviz graph resolution (dpi) */

};

#endif // GRAPHICDAG_HPP
