#ifndef GRAPHICEDGE_HPP
#define GRAPHICEDGE_HPP

#include "../Common.hpp"
#include <QtGui>

class GraphicEdge : public QGraphicsItem {

public:

  //////////////////////////////////////////////////////////////////////////////
  // CONSTRUCTOR & DESTRUCTOR

  GraphicEdge(Agedge_t* ep, QGraphicsItem * parent = 0);

  ~GraphicEdge();

  //////////////////////////////////////////////////////////////////////////////
  // METHODS

  /**
   * @reimp
   */
  QRectF boundingRect() const;

  /**
   * @reimp
   */
  void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,QWidget *widget);

private:

  //////////////////////////////////////////////////////////////////////////////
  // METHODS

  QGraphicsPolygonItem* createArrowHead(QString attr);

  //////////////////////////////////////////////////////////////////////////////
  // VARIABLES

  QColor edgeColor;
  QPen edgePen;
  QBrush edgeBrush;
  QBrush arrowHeadBrush;
  QGraphicsPathItem* pathItem;
  QGraphicsPolygonItem* headArrowHeadItem;
  //QGraphicsTextItem* label;
  QRectF boundingBox;

};

#endif // GRAPHICEDGE_HPP
