#ifndef GRAPHICNODE_HPP
#define GRAPHICNODE_HPP

#include "../Common.hpp"
#include <QtGui>

class GraphicNode : public QGraphicsItem
{

public:

  //////////////////////////////////////////////////////////////////////////////
  // CONSTRUCTOR & DESTRUCTOR

  GraphicNode(Agnode_t* np, double _resolution, QGraphicsItem * parent = 0);

  ~GraphicNode();

  //////////////////////////////////////////////////////////////////////////////
  // METHODS

  /**
   * @reimp
   */
  QRectF boundingRect() const;

  /**
   * @reimp
   */
  void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,QWidget *widget);

private:

  //////////////////////////////////////////////////////////////////////////////
  // METHODS


  //////////////////////////////////////////////////////////////////////////////
  // VARIABLES

  QColor shapeBgColor;
  QPen shapePen;
  QBrush shapeBrush;
  QGraphicsRectItem* rectItem;
  QGraphicsSimpleTextItem* textItem;
  QRectF boundingBox;

  const double RESOLUTION;

};

#endif // GRAPHICNODE_HPP
