#ifndef GRAPHICTIDLISTBAR_HPP
#define GRAPHICTIDLISTBAR_HPP

#include "../logic/DagStructure.hpp"

#include <QtGui>

class GraphicTidListBar : public QGraphicsItem {

public:

  // Colors mods enum
  enum COLOR_MODS {
    LINEAR_GRAYSCALE,
    LINEAR_1,
    LINEAR_2,
    LINEAR_3_COLORS,
    LINEAR_5_COLORS,
    NONLINEAR_5_COLORS,
    LINEAR_6_COLORS,
    NONLINEAR_5_COLORS_2,
    COLOR_MODS_COUNT
  };


  //////////////////////////////////////////////////////////////////////////////
  // CONSTRUCTORS & DESTRUCTOR

  GraphicTidListBar(QGraphicsItem * parent = 0);

  ~GraphicTidListBar();


  //////////////////////////////////////////////////////////////////////////////
  // METHODS

  /**
     * @reimp
     */
  QRectF boundingRect() const;

  /**
     * @reimp
     */
  void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,QWidget *widget);

  void updateRatesList();


  //////////////////////////////////////////////////////////////////////////////
  // GETTERS & SETTERS

  bool isReady() const;

  void setSize(QSize _size);

  void setWidth(int _width);

  void setHeight(int _height);

  void setInputDagsMap(QMap<int, QString> *_inputDagsList);

  void setTidList(QList<int> *_tidList);

  void setColorMode(int _mode);


private:

  //////////////////////////////////////////////////////////////////////////////
  // METHODS

  void resetBoolMap();

  QColor calculateColor(double value);

  QColor colorLinearInterpolation(QColor c1, QColor c2, double alpha);


  //////////////////////////////////////////////////////////////////////////////
  // VARIABLES

  QMap<int, QString> *pInputDagsMap;
  QList<int> *pTidList;
  QMap<int, boolean> boolMap;
  QList<double> ratesList;

  QSize size;
  int barHeight;
  int tickHeight;
  int fontSize;
  int dagsPerPixel;
  int colorMode;

};

#endif // GRAPHICTIDLISTBAR_HPP
