/**
 * @file MainWindow.hpp
 *
 * Created on 2010/05/XX by Anthony Nemoff
 * Last update 2010/06/04 by Anthony Nemoff
 *
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QGraphicsScene>
#include <QGraphicsView>

#include "../Common.hpp"
#include "../logic/DigDagData.hpp"
#include "ExplorerDock.hpp"
#include "CurrentDagDock.hpp"
#include "GraphicTidListBar.hpp"
#include "TidListDockWidget.hpp"
#include "RunDigDagDialog.hpp"


namespace Ui {
  class MainWindow;
}

/**
 * Main GUI class
 */
class MainWindow : public QMainWindow {
  Q_OBJECT

public:

  // Consctructor
  MainWindow(QWidget *parent = 0);

  // Destructor
  ~MainWindow();

  // Public methods

  void displayDagPattern(int index);

  void displayInputPattern(int index);

  void displayInputDag(int inputDagIndex);


protected:

  // Protected methods
  void changeEvent(QEvent *e);

private:

  // Private methods
  void connectSlots();


  // Members

  // GUI objects
  Ui::MainWindow *_ui;
  QGraphicsScene *_graphicScene;
  QGraphicsView *_graphicView;
  RunDigDagDialog* _runDigDagDialog;

  DigDagData* _digDagData;

  // Docks
  ExplorerDock* _explorerDock;
  CurrentDagDock* _currentDagDock;
  TidListDockWidget *_tidListDock;

  // TODO read & write settings
  QSettings appSettings;


private slots:

  //////////////////////////////////////////////////////////////////////////////
  // SLOTS

  // File menu slots
  void runDigDag();
  void openFile();
  void closeFile();
  void closeAndCompressFile();
  void exportDag();
  void quitApp();

  // Navigation menu slots
  void showAssociatedDag();
  void jumpToDagPattern();
  //void jumpToInput();

  // Display menu slots
  void showToolbar(bool isVisible);
  void showExplorerDock(bool isVisible);
  void showDagPropertiesDock(bool isVisible);
  void showTidListDock(bool isVisible);
  void enableAntialiasing(bool isEnabled);

  // Tools menu slots

  // Help menu slots

};

#endif // MAINWINDOW_H
