#ifndef RUNDIGDAGDIALOG_HPP
#define RUNDIGDAGDIALOG_HPP

#include <QDialog>

namespace Ui {
  class RunDigDagDialog;
}

class RunDigDagDialog : public QDialog {
  Q_OBJECT

public:

  enum FINAL_ACTION {
    OPEN_FILE,
    DO_NOTHING
  };

  explicit RunDigDagDialog(QWidget *parent = 0);

  ~RunDigDagDialog();

  // Getters & setters

  QString getDigDagPath();

  QString getInputFolderName();

  bool isSortEnabled();

  int getMinSupport();

  int getEPThreshold();

  QString getOutputPrefix();

  int getFinalAction();



private:

  // Private methods

  void connectSlots();

  void updateAutomaticOutputFileName();


  // Members
  Ui::RunDigDagDialog *_ui;
  QString _oldOutputFileName;


private slots:

  void on_epThresholdSpinBox_valueChanged(int );

  void on_minSupportSpinBox_valueChanged(int );

  void on_minSupportHorizontalSlider_valueChanged(int value);

  void openDigDagPathDialog();

  void openInputFolderDialog();

  void openOutputFolderDialog();

  void checkAutomaticOutputName(bool on);


};

#endif // RUNDIGDAGDIALOG_HPP
