#include "TidListDockWidget.hpp"
#include "ui_TidListDockWidget.h"

TidListDockWidget::TidListDockWidget(QWidget *parent) :
    QDockWidget(parent),
    ui(new Ui::TidListDockWidget)
{
  ui->setupUi(this);

  // Create scene
  scene = new QGraphicsScene(this);
  scene->setBackgroundBrush(Qt::white);

  // Link scene to the view
  ui->graphicsView->setScene(scene);
  ui->graphicsView->setBackgroundBrush(Qt::white);
  ui->graphicsView->setDragMode(QGraphicsView::ScrollHandDrag);

  // Create bar and add to the scene
  bar = new GraphicTidListBar();
  //bar->setSize(ui->graphicsView->geometry().size());
  bar->setSize(QSize(1100, 60));
  scene->addItem(bar);

  initColorModesComboBox();
  bar->setColorMode(ui->colorModeComboBox->currentIndex());

  // !!! All GUI objects now created !!!

  // Create connections between GUI objects and slots
  connectSlots();

}

TidListDockWidget::~TidListDockWidget() {

  delete bar;
  delete ui;

}


////////////////////////////////////////////////////////////////////////////
// GETTERS & SETTERS
void TidListDockWidget::setInputDagsMap(QMap<int, QString> *_inputDagsList) {

  bar->setInputDagsMap(_inputDagsList);

}

void TidListDockWidget::setTidList(QList<int> *_tidList) {

  bar->setTidList(_tidList);
  bar->updateRatesList();

}

////////////////////////////////////////////////////////////////////////////
// METHODS

void TidListDockWidget::connectSlots() {

  //QObject::connect(ui->graphicsView, SIGNAL())

  // Color mode ComboBox
  QObject::connect(ui->colorModeComboBox, SIGNAL(currentIndexChanged(int)), this, SLOT(changeColorMode(int)));

}


void TidListDockWidget::initColorModesComboBox() {

  // Refer to GraphicTidListBar.hpp for enum COLORS_MODS
  ui->colorModeComboBox->insertItem(GraphicTidListBar::LINEAR_GRAYSCALE, tr("Linear grayscale"));
  ui->colorModeComboBox->insertItem(GraphicTidListBar::LINEAR_1, tr("Linear 1"));
  ui->colorModeComboBox->insertItem(GraphicTidListBar::LINEAR_2, tr("Linear 2"));
  ui->colorModeComboBox->insertItem(GraphicTidListBar::LINEAR_3_COLORS, tr("Linear 3 colors"));
  ui->colorModeComboBox->insertItem(GraphicTidListBar::LINEAR_5_COLORS, tr("Linear color gradient"));
  ui->colorModeComboBox->insertItem(GraphicTidListBar::NONLINEAR_5_COLORS, tr("Non-linear color gradient"));
  ui->colorModeComboBox->insertItem(GraphicTidListBar::LINEAR_6_COLORS, tr("Linear color gradient 2"));
  ui->colorModeComboBox->insertItem(GraphicTidListBar::NONLINEAR_5_COLORS_2, tr("Non-linear color gradient 2"));

  ui->colorModeComboBox->blockSignals(true);
  ui->colorModeComboBox->setCurrentIndex(GraphicTidListBar::LINEAR_GRAYSCALE);
  ui->colorModeComboBox->blockSignals(false);

}



////////////////////////////////////////////////////////////////////////////
// SLOTS

/**
 * Sets the selected combobox value as the new color mode for the tid list bar.
 *
 * @param index Selected index in the combobox
 */
void TidListDockWidget::changeColorMode(int index) {

  bar->setColorMode(index);

}
