#ifndef TIDLISTDOCKWIDGET_HPP
#define TIDLISTDOCKWIDGET_HPP

#include <QtGui>
#include "GraphicTidListBar.hpp"

namespace Ui {
    class TidListDockWidget;
}

class TidListDockWidget : public QDockWidget {

    Q_OBJECT

public:
    explicit TidListDockWidget(QWidget *parent = 0);

    ~TidListDockWidget();

    ////////////////////////////////////////////////////////////////////////////
    // GETTERS & SETTERS

    void setInputDagsMap(QMap<int, QString> *_inputDagsList);

    void setTidList(QList<int> *_tidList);

private:

    ////////////////////////////////////////////////////////////////////////////
    // METHODS

    void connectSlots();

    void initColorModesComboBox();

    ////////////////////////////////////////////////////////////////////////////
    // VARIABLES

    Ui::TidListDockWidget *ui;

    QGraphicsScene *scene;
    GraphicTidListBar *bar;

private slots:
    void changeColorMode(int index);
};

#endif // TIDLISTDOCKWIDGET_HPP
