#ifndef ABSTRACTDAG_HPP
#define ABSTRACTDAG_HPP

#include "../Common.hpp"
#include "DagStructure.hpp"

/**
 * An abstract DAG is the base clase for DagPattern and DagInput. It is not
 * intented to be instantied as an object.
 *
 * @author Anthony Nemoff
 * @version 2010/07/21
 */
class AbstractDag {

public:

  // DAG types
  enum DAG_TYPES {
    DAG_PATTERN,
    DAG_INPUT,
    DAG_NUMBER_OF_TYPES
  };

  // Constructors
  AbstractDag();

  AbstractDag(QString graphName, int numberOfNodes, int numberOfEdges, GVC_t *graphvizContext);

  ~AbstractDag();


  // Getters & setters

  DagStructure* getStructure();

  virtual int getDagType() const = 0; // Pure virtual method

  virtual QString getDagTypeString() const = 0; // Pure virtual method


private:

  // Variables

  DagStructure _structure; /**< Graph model */

};

#endif // ABSTRACTDAG_HPP
