#ifndef DAGPATTERN_HPP
#define DAGPATTERN_HPP

#include "AbstractDag.hpp"

/**
 * This class represents a DAG pattern with its graph structure, properties and
 * TID list.
 *
 * @author Anthony Nemoff
 * @version 2010/07/28
 */
class DagPattern : public AbstractDag {

public:

  // Constructors

  DagPattern(); // XXX Useless constructor ?

  DagPattern(int index, QString _graphName, int _numberOfNodes, int _numberOfEdges, GVC_t *_graphvizContext);


  // Getters & setters

  int getDagType() const;

  QString getDagTypeString() const;

  void setIndex(int dagPatternIndex);

  int getIndex() const;

  void setLoaded(bool loaded);

  int isLoaded() const;

  void setSupport(int support);

  int getSupport() const;

  void setDagDescriptionPos(qint64 filePosition);

  qint64 getDagDescriptionPos() const;

  void appendInputDagIndex(int inputDagIndex);

  QList<int>* getTidList() ;


private:

  // Variables

  int _index; /**< The DAG pattern index */

  bool _loaded; /**< Indicates the loaded status of the object: true if all
    DAG information is loaded, or false if partially loaded */

  int _support; /**< Number of input DAGs in which this DAG pattern appears */

  qint64 _dagDescriptionPos; /**< File position of the DAG description section */

  QList<int> _tidList; /** < Ordered list of input DAGs indexes */

};

#endif // DAGPATTERN_HPP
