#include "InputDag.hpp"
#include <QtAlgorithms>
#include <QObject>

/**
 *
 */
InputDag::InputDag(int index, QString dagFileName, QString graphName, GVC_t *graphvizContext) :
    AbstractDag(graphName, -1, -1, graphvizContext),
    _index(index),
    _dagFileName(dagFileName),
    _dagStructureLoaded(false)
{
}

//==============================================================================
// Getters & setters

/**
 * Returns an int value identifying the DAG Pattern type.
 *
 * @return Integer value identifying the DAG pattern type.
 * @see AbstractDag.hpp
 */
int InputDag::getDagType() const {
  return AbstractDag::DAG_INPUT;
}


/**
 * Returns a string describing the DAG type
 *
 * @return A string describing the DAG type
 */
QString InputDag::getDagTypeString() const {
  return QObject::tr("Input");
}

/**
 * Returns a pointer to the supported patterns list.
 */
QList<int>* InputDag::getSupportedPatterns() {
  return &_supportedPatterns;
}


/**
 * Returns the size of the supported patterns list.
 */
int InputDag::getNumberOfSupportedPatterns() {
  return _supportedPatterns.size();
}


/**
 *
 */
int InputDag::getIndex() {
  return _index;
}


/**
 *
 */
QString InputDag::getDagFileName() {
  return _dagFileName;
}


/**
 *
 */
void InputDag::setDagStructureLoaded(bool loaded) {
  _dagStructureLoaded = loaded;
}


/**
 *
 */
bool InputDag::isDagStructureLoaded() {
  return _dagStructureLoaded;
}


//==============================================================================
// Methods

/**
 * Adds the given pattern index to the list of supported patterns.
 *
 * @param index The pattern index to add to the list
 */
void InputDag::appendPatternIndex(int index) {
  _supportedPatterns.append(index);
}

/**
 * Sorts the supported patterns indexes in ascending order.
 */
void InputDag::sortSupportedPatternsAscending() {
  qSort(_supportedPatterns.begin(), _supportedPatterns.end());
}
