#ifndef INPUTDAG_HPP
#define INPUTDAG_HPP

#include "../Common.hpp"
#include "AbstractDag.hpp"


/**
 * This class represents an input DAG that was used to extract patterns DAGs.
 * Each input dag is physically stored in a separate .dag file, and must be loaded
 * individually by DigDagData.
 */
class InputDag : public AbstractDag {

public:

  // Constructor
  InputDag(int index, QString dagFileName, QString graphName, GVC_t *graphvizContext);


  // Getters & setters

  int getDagType() const;

  QString getDagTypeString() const;

  QList<int>* getSupportedPatterns();

  int getNumberOfSupportedPatterns();

  int getIndex();

  QString getDagFileName();

  void setDagStructureLoaded(bool loaded);

  bool isDagStructureLoaded();


  // Methods
  void appendPatternIndex(int patternIndex);

  void sortSupportedPatternsAscending();


private:

  // Members
  int _index;
  QString _dagFileName;
  QList<int> _supportedPatterns;
  bool _dagStructureLoaded;

};

#endif // INPUTDAG_HPP
