/**
 * 
 */
package com.anemoff.android.taquin.model;

import android.graphics.Bitmap;
import android.graphics.Color;

/**
 * Une case du plateau de jeu, représenté par sa position courante sur le
 * plateau de jeu, la position à atteindre (pour qu'elle soit bien placée), et
 * l'image qu'elle contient.
 * 
 * @author anemoff
 * 
 */
public class Cell {

	/** Position courante de la case sur le plateau de jeu */
	private int currentPosition;

	/**
	 * Position destination de la case à atteindre. Cette valeur sert aussi
	 * d'identifiant pour la case.
	 */
	private int targetPosition;

	/** L'image contenue dans la case. */
	private Bitmap bitmap;

	/** Drapeau indiquant s'il s'agit de la case vide du plateau. */
	private boolean isEmpty;

	/**
	 * Construit une nouvelle case, avec sa position initiale sur le plateau, et
	 * son image.
	 * 
	 * @param startPosition
	 *            Position initiale de la case.
	 * @param bitmap
	 *            Bitmap représentant la case.
	 */
	public Cell(int startPosition, Bitmap bitmap) {
		this.currentPosition = startPosition;
		this.targetPosition = startPosition;
		this.bitmap = bitmap;
	}

	public int getCurrentPosition() {
		return currentPosition;
	}

	public void setCurrentPosition(int currentPosition) {
		this.currentPosition = currentPosition;
	}

	public int getTargetPosition() {
		return targetPosition;
	}

	public void setTargetPosition(int targetPosition) {
		this.targetPosition = targetPosition;
	}

	public Bitmap getBitmap() {
		return bitmap;
	}

	public void setImage(Bitmap image) {
		this.bitmap = image;
	}

	/**
	 * Retourne true si la case est vide.
	 * 
	 * @return
	 */
	public boolean isEmpty() {
		return isEmpty;
	}

	/**
	 * Mets à true le drapeau indiquant que la case est vide, et remplace
	 * l'image par un remplissage noir.
	 * 
	 * @param isEmpty
	 */
	public void setEmpty(boolean isEmpty) {
		this.isEmpty = isEmpty;
		bitmap.eraseColor(Color.BLACK);
	}

	/**
	 * Retourne true si la case se trouve à la bonne position sur le plateau.
	 * 
	 * @return
	 */
	public boolean isAtTarget() {
		return currentPosition == targetPosition;
	}

	@Override
	public String toString() {
		String string = "Cell: pos=" + currentPosition + ", target="
				+ targetPosition;

		if (isEmpty)
			string += ", EMPTY";

		return string;
	}

}
