/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.scalar;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private BufferedImage image;
    private TexturePaint background;

    public ImagePanel() {
        Color base = Color.gray;
        BufferedImage image = new BufferedImage(50, 50, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setColor(base);
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        g.setColor(base.darker());
        g.fillRect(image.getWidth() / 2, 0, image.getWidth() / 2, image.getHeight() / 2);
        g.fillRect(0, image.getHeight() / 2, image.getWidth() / 2, image.getHeight() / 2);
        this.background = new TexturePaint(image, new Rectangle(0, 0, image.getWidth(), image.getHeight()));
        this.setBackground(Color.black);
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
        this.setSize(new Dimension(image.getWidth(), image.getHeight()));
        this.getParent().repaint(0L);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void paint(Graphics g1d) {
        Graphics2D g = (Graphics2D)g1d;
        super.paint(g);
        g.setPaint(this.background);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.image != null) {
            g.drawImage((Image)this.image, 0, 0, null);
        }
    }
}

