/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.scalar;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.newdawn.slick.tools.scalar.RawScale3x;

public class ImageScale3x {
    private int[] srcData;
    private int width;
    private int height;

    public ImageScale3x(BufferedImage srcImage) {
        this.width = srcImage.getWidth();
        this.height = srcImage.getHeight();
        this.srcData = new int[this.width * this.height];
        srcImage.getRGB(0, 0, this.width, this.height, this.srcData, 0, this.width);
    }

    public BufferedImage getScaledImage() {
        RawScale3x scaler = new RawScale3x(this.srcData, this.width, this.height);
        BufferedImage image = new BufferedImage(this.width * 3, this.height * 3, 2);
        image.setRGB(0, 0, this.width * 3, this.height * 3, scaler.getScaledData(), 0, this.width * 3);
        return image;
    }

    public static void main(String[] argv) {
        String srcFile = "randam_orig.png";
        try {
            System.out.println("Reading: " + srcFile);
            BufferedImage src = ImageIO.read(new File(srcFile));
            ImageScale3x scaler = new ImageScale3x(src);
            BufferedImage out = scaler.getScaledImage();
            String outFile = srcFile.substring(0, srcFile.length() - 4);
            outFile = outFile + "3x";
            outFile = outFile + ".png";
            System.out.println("Writing: " + outFile);
            ImageIO.write((RenderedImage)out, "PNG", new File(outFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

