/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.serialization.pb;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.box2d.proto.Box2D;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.Filter;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.joints.ConstantVolumeJoint;
import org.jbox2d.dynamics.joints.DistanceJoint;
import org.jbox2d.dynamics.joints.FrictionJoint;
import org.jbox2d.dynamics.joints.GearJoint;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.LineJoint;
import org.jbox2d.dynamics.joints.MouseJoint;
import org.jbox2d.dynamics.joints.PrismaticJoint;
import org.jbox2d.dynamics.joints.PulleyJoint;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.serialization.JbSerializer;
import org.jbox2d.serialization.SerializationHelper;
import org.jbox2d.serialization.SerializationResult;
import org.jbox2d.serialization.UnsupportedListener;
import org.jbox2d.serialization.UnsupportedObjectException;

public class PbSerializer
implements JbSerializer {
    private JbSerializer.ObjectSigner signer = null;
    private UnsupportedListener listener = null;

    public PbSerializer() {
    }

    public PbSerializer(UnsupportedListener argListener) {
        this.listener = argListener;
    }

    public PbSerializer(JbSerializer.ObjectSigner argSigner) {
        this.signer = argSigner;
    }

    public PbSerializer(UnsupportedListener argListener, JbSerializer.ObjectSigner argSigner) {
        this.listener = argListener;
        this.signer = argSigner;
    }

    @Override
    public void setObjectSigner(JbSerializer.ObjectSigner argSigner) {
        this.signer = argSigner;
    }

    @Override
    public void setUnsupportedListener(UnsupportedListener argListener) {
        this.listener = argListener;
    }

    @Override
    public SerializationResult serialize(World argWorld) {
        final Box2D.PbWorld world = this.serializeWorld(argWorld).build();
        return new SerializationResult(){

            @Override
            public void writeTo(OutputStream argOutputStream) throws IOException {
                world.writeTo(argOutputStream);
            }

            @Override
            public Object getValue() {
                return world;
            }
        };
    }

    public Box2D.PbWorld.Builder serializeWorld(World argWorld) {
        Long tag;
        Box2D.PbWorld.Builder builder = Box2D.PbWorld.newBuilder();
        if (this.signer != null && (tag = this.signer.getTag(argWorld)) != null) {
            builder.setTag(tag);
        }
        builder.setGravity(this.vecToPb(argWorld.getGravity()));
        builder.setAllowSleep(argWorld.isAllowSleep());
        builder.setContinuousPhysics(argWorld.isContinuousPhysics());
        builder.setWarmStarting(argWorld.isWarmStarting());
        Body cbody = argWorld.getBodyList();
        int cnt = 0;
        HashMap<Body, Integer> bodies = new HashMap<Body, Integer>();
        while (cbody != null) {
            builder.addBodies(this.serializeBody(cbody));
            bodies.put(cbody, cnt);
            ++cnt;
            cbody = cbody.m_next;
        }
        cnt = 0;
        HashMap<Joint, Integer> joints = new HashMap<Joint, Integer>();
        Joint cjoint = argWorld.getJointList();
        while (cjoint != null) {
            if (SerializationHelper.isIndependentJoint(cjoint.getType())) {
                builder.addJoints(this.serializeJoint(cjoint, bodies, joints));
                joints.put(cjoint, cnt);
                ++cnt;
            }
            cjoint = cjoint.m_next;
        }
        cjoint = argWorld.getJointList();
        while (cjoint != null) {
            if (!SerializationHelper.isIndependentJoint(cjoint.getType())) {
                builder.addJoints(this.serializeJoint(cjoint, bodies, joints));
                joints.put(cjoint, cnt);
                ++cnt;
            }
            cjoint = cjoint.m_next;
        }
        return builder;
    }

    @Override
    public SerializationResult serialize(Body argBody) {
        Box2D.PbBody.Builder builder = this.serializeBody(argBody);
        if (builder == null) {
            return null;
        }
        final Box2D.PbBody body = builder.build();
        return new SerializationResult(){

            @Override
            public void writeTo(OutputStream argOutputStream) throws IOException {
                body.writeTo(argOutputStream);
            }

            @Override
            public Object getValue() {
                return body;
            }
        };
    }

    public Box2D.PbBody.Builder serializeBody(Body argBody) {
        Long id;
        Box2D.PbBody.Builder builder = Box2D.PbBody.newBuilder();
        if (this.signer != null && (id = this.signer.getTag(argBody)) != null) {
            builder.setTag(id);
        }
        switch (argBody.getType()) {
            case DYNAMIC: {
                builder.setType(Box2D.PbBodyType.DYNAMIC);
                break;
            }
            case KINEMATIC: {
                builder.setType(Box2D.PbBodyType.KINEMATIC);
                break;
            }
            case STATIC: {
                builder.setType(Box2D.PbBodyType.STATIC);
                break;
            }
            default: {
                UnsupportedObjectException e = new UnsupportedObjectException("Unknown body type: " + (Object)((Object)argBody.getType()), UnsupportedObjectException.Type.BODY);
                if (this.listener == null || this.listener.isUnsupported(e)) {
                    throw e;
                }
                return null;
            }
        }
        builder.setPosition(this.vecToPb(argBody.getPosition()));
        builder.setAngle(argBody.getAngle());
        builder.setLinearVelocity(this.vecToPb(argBody.getLinearVelocity()));
        builder.setAngularVelocity(argBody.getAngularVelocity());
        builder.setLinearDamping(argBody.getLinearDamping());
        builder.setAngularDamping(argBody.getAngularDamping());
        builder.setForce(this.vecToPb(argBody.m_force));
        builder.setTorque(argBody.m_torque);
        builder.setBullet(argBody.isBullet());
        builder.setAllowSleep(argBody.isSleepingAllowed());
        builder.setAwake(argBody.isAwake());
        builder.setActive(argBody.isActive());
        builder.setFixedRotation(argBody.isFixedRotation());
        builder.setMass(argBody.m_mass);
        builder.setI(argBody.m_I);
        Fixture curr = argBody.m_fixtureList;
        while (curr != null) {
            builder.addFixtures(this.serializeFixture(curr));
            curr = curr.m_next;
        }
        return builder;
    }

    @Override
    public SerializationResult serialize(Fixture argFixture) {
        final Box2D.PbFixture fixture = this.serializeFixture(argFixture).build();
        return new SerializationResult(){

            @Override
            public void writeTo(OutputStream argOutputStream) throws IOException {
                fixture.writeTo(argOutputStream);
            }

            @Override
            public Object getValue() {
                return fixture;
            }
        };
    }

    public Box2D.PbFixture.Builder serializeFixture(Fixture argFixture) {
        Long tag;
        Box2D.PbFixture.Builder builder = Box2D.PbFixture.newBuilder();
        if (this.signer != null && (tag = this.signer.getTag(argFixture)) != null) {
            builder.setTag(tag);
        }
        builder.setDensity(argFixture.m_density);
        builder.setFriction(argFixture.m_friction);
        builder.setRestitution(argFixture.m_restitution);
        builder.setSensor(argFixture.m_isSensor);
        builder.setShape(this.serializeShape(argFixture.m_shape));
        builder.setFilter(this.serializeFilter(argFixture.m_filter));
        return builder;
    }

    @Override
    public SerializationResult serialize(Shape argShape) {
        Box2D.PbShape.Builder builder = this.serializeShape(argShape);
        if (builder == null) {
            return null;
        }
        final Box2D.PbShape shape = builder.build();
        return new SerializationResult(){

            @Override
            public void writeTo(OutputStream argOutputStream) throws IOException {
                shape.writeTo(argOutputStream);
            }

            @Override
            public Object getValue() {
                return shape;
            }
        };
    }

    public Box2D.PbShape.Builder serializeShape(Shape argShape) {
        Long tag;
        Box2D.PbShape.Builder builder = Box2D.PbShape.newBuilder();
        if (this.signer != null && (tag = this.signer.getTag(argShape)) != null) {
            builder.setTag(tag);
        }
        builder.setRadius(argShape.m_radius);
        switch (argShape.m_type) {
            case CIRCLE: {
                CircleShape c = (CircleShape)argShape;
                builder.setCenter(this.vecToPb(c.m_p));
                builder.setType(Box2D.PbShapeType.CIRCLE);
                break;
            }
            case POLYGON: {
                PolygonShape p = (PolygonShape)argShape;
                builder.setCentroid(this.vecToPb(p.m_centroid));
                builder.setType(Box2D.PbShapeType.POLYGON);
                for (int i = 0; i < p.m_vertexCount; ++i) {
                    builder.addPoints(this.vecToPb(p.m_vertices[i]));
                    builder.addNormals(this.vecToPb(p.m_normals[i]));
                }
                break;
            }
            default: {
                UnsupportedObjectException e = new UnsupportedObjectException("Currently only encodes circle and polygon shapes", UnsupportedObjectException.Type.SHAPE);
                if (this.listener == null || this.listener.isUnsupported(e)) {
                    throw e;
                }
                return null;
            }
        }
        return builder;
    }

    @Override
    public SerializationResult serialize(Joint argJoint, Map<Body, Integer> argBodyIndexMap, Map<Joint, Integer> argJointIndexMap) {
        Box2D.PbJoint.Builder builder = this.serializeJoint(argJoint, argBodyIndexMap, argJointIndexMap);
        if (builder == null) {
            return null;
        }
        final Box2D.PbJoint joint = builder.build();
        return new SerializationResult(){

            @Override
            public void writeTo(OutputStream argOutputStream) throws IOException {
                joint.writeTo(argOutputStream);
            }

            @Override
            public Object getValue() {
                return joint;
            }
        };
    }

    public Box2D.PbJoint.Builder serializeJoint(Joint argJoint, Map<Body, Integer> argBodyIndexMap, Map<Joint, Integer> argJointIndexMap) {
        Long tag;
        Box2D.PbJoint.Builder builder = Box2D.PbJoint.newBuilder();
        if (this.signer != null && (tag = this.signer.getTag(argJoint)) != null) {
            builder.setTag(tag);
        }
        Body bA = argJoint.m_bodyA;
        Body bB = argJoint.m_bodyB;
        if (!argBodyIndexMap.containsKey(bA)) {
            throw new IllegalArgumentException("Body " + bA + " is not present in the index map");
        }
        builder.setBodyA(argBodyIndexMap.get(bA));
        if (!argBodyIndexMap.containsKey(bB)) {
            throw new IllegalArgumentException("Body " + bB + " is not present in the index map");
        }
        builder.setBodyB(argBodyIndexMap.get(bB));
        builder.setCollideConnected(argJoint.m_collideConnected);
        switch (argJoint.m_type) {
            case REVOLUTE: {
                RevoluteJoint j = (RevoluteJoint)argJoint;
                builder.setType(Box2D.PbJointType.REVOLUTE);
                builder.setRefAngle(j.m_referenceAngle);
                builder.setEnableLimit(j.m_enableLimit);
                builder.setLowerLimit(j.m_lowerAngle);
                builder.setUpperLimit(j.m_upperAngle);
                builder.setEnableMotor(j.m_enableMotor);
                builder.setMotorSpeed(j.m_motorSpeed);
                builder.setMaxMotorTorque(j.m_maxMotorTorque);
                builder.setLocalAnchorA(this.vecToPb(j.m_localAnchor1));
                builder.setLocalAnchorB(this.vecToPb(j.m_localAnchor2));
                break;
            }
            case PRISMATIC: {
                PrismaticJoint j = (PrismaticJoint)argJoint;
                builder.setType(Box2D.PbJointType.PRISMATIC);
                builder.setRefAngle(j.m_refAngle);
                builder.setEnableLimit(j.m_enableLimit);
                builder.setLowerLimit(j.m_lowerTranslation);
                builder.setUpperLimit(j.m_upperTranslation);
                builder.setEnableMotor(j.m_enableMotor);
                builder.setMotorSpeed(j.m_motorSpeed);
                builder.setLocalAnchorA(this.vecToPb(j.m_localAnchor1));
                builder.setLocalAnchorB(this.vecToPb(j.m_localAnchor2));
                builder.setLocalAxisA(this.vecToPb(j.m_localXAxis1));
                builder.setMaxMotorForce(j.m_maxMotorForce);
                break;
            }
            case DISTANCE: {
                DistanceJoint j = (DistanceJoint)argJoint;
                builder.setType(Box2D.PbJointType.DISTANCE);
                builder.setLocalAnchorA(this.vecToPb(j.m_localAnchor1));
                builder.setLocalAnchorB(this.vecToPb(j.m_localAnchor2));
                builder.setLength(j.m_length);
                builder.setFrequency(j.m_frequencyHz);
                builder.setDampingRatio(j.m_dampingRatio);
                break;
            }
            case PULLEY: {
                PulleyJoint j = (PulleyJoint)argJoint;
                builder.setType(Box2D.PbJointType.PULLEY);
                builder.setLocalAnchorA(this.vecToPb(j.m_localAnchor1));
                builder.setLocalAnchorB(this.vecToPb(j.m_localAnchor2));
                builder.setGroundAnchorA(this.vecToPb(j.m_groundAnchor1));
                builder.setGroundAnchorB(this.vecToPb(j.m_groundAnchor2));
                builder.setLengthA(j.getOrigLength1());
                builder.setLengthB(j.getOrigLength2());
                builder.setMaxLengthA(j.getMaxLength1());
                builder.setMaxLengthB(j.getMaxLength2());
                builder.setRatio(j.getRatio());
                break;
            }
            case MOUSE: {
                MouseJoint j = (MouseJoint)argJoint;
                builder.setType(Box2D.PbJointType.MOUSE);
                builder.setTarget(this.vecToPb(j.getTarget()));
                builder.setMaxForce(j.getMaxForce());
                builder.setFrequency(j.getFrequency());
                builder.setDampingRatio(j.getDampingRatio());
                break;
            }
            case GEAR: {
                GearJoint j = (GearJoint)argJoint;
                builder.setType(Box2D.PbJointType.GEAR);
                builder.setLocalAnchorA(this.vecToPb(j.m_localAnchor1));
                builder.setLocalAnchorB(this.vecToPb(j.m_localAnchor2));
                builder.setRatio(j.getRatio());
                if (!argJointIndexMap.containsKey(j.getJoint1())) {
                    throw new IllegalArgumentException("Joint 1 not in map");
                }
                int j1 = argJointIndexMap.get(j.getJoint1());
                if (!argJointIndexMap.containsKey(j.getJoint2())) {
                    throw new IllegalArgumentException("Joint 2 not in map");
                }
                int j2 = argJointIndexMap.get(j.getJoint2());
                builder.setJoint1(j1);
                builder.setJoint2(j2);
                break;
            }
            case FRICTION: {
                FrictionJoint j = (FrictionJoint)argJoint;
                builder.setType(Box2D.PbJointType.FRICTION);
                builder.setLocalAnchorA(this.vecToPb(j.getLocalAnchorA()));
                builder.setLocalAnchorB(this.vecToPb(j.getLocalAnchorB()));
                builder.setMaxForce(j.getMaxForce());
                builder.setMaxTorque(j.getMaxTorque());
                break;
            }
            case CONSTANT_VOLUME: {
                ConstantVolumeJoint j = (ConstantVolumeJoint)argJoint;
                builder.setType(Box2D.PbJointType.CONSTANT_VOLUME);
                builder.setFrequency(j.frequencyHz);
                builder.setDampingRatio(j.dampingRatio);
                builder.setTargetVolume(j.targetVolume);
                for (int i = 0; i < j.bodies.length; ++i) {
                    Body b = j.bodies[i];
                    DistanceJoint djoint = j.getJoints()[i];
                    if (!argBodyIndexMap.containsKey(b)) {
                        throw new IllegalArgumentException("Body " + b + " is not present in the index map");
                    }
                    builder.addBodies(argBodyIndexMap.get(b));
                    if (!argJointIndexMap.containsKey(djoint)) {
                        throw new IllegalArgumentException("Joint " + djoint + " is not present in the index map");
                    }
                    builder.addJoints(argJointIndexMap.get(djoint));
                }
                break;
            }
            case LINE: {
                LineJoint j = (LineJoint)argJoint;
                builder.setType(Box2D.PbJointType.LINE);
                builder.setLocalAnchorA(this.vecToPb(j.m_localAnchor1));
                builder.setLocalAnchorB(this.vecToPb(j.m_localAnchor2));
                builder.setLocalAxisA(this.vecToPb(j.m_localXAxis1));
                builder.setLowerLimit(j.getLowerLimit());
                builder.setUpperLimit(j.getUpperLimit());
                builder.setMaxMotorForce(j.getMaxMotorForce());
                builder.setMotorSpeed(j.getMotorSpeed());
                builder.setEnableLimit(j.isLimitEnabled());
                builder.setEnableMotor(j.isMotorEnabled());
                break;
            }
            default: {
                UnsupportedObjectException e = new UnsupportedObjectException("Unknown joint type: " + (Object)((Object)argJoint.getType()), UnsupportedObjectException.Type.JOINT);
                if (this.listener == null || this.listener.isUnsupported(e)) {
                    throw e;
                }
                return null;
            }
        }
        return builder;
    }

    public Box2D.PbFilter.Builder serializeFilter(Filter argFilter) {
        Box2D.PbFilter.Builder builder = Box2D.PbFilter.newBuilder();
        builder.setCategoryBits(argFilter.categoryBits);
        builder.setGroupIndex(argFilter.groupIndex);
        builder.setMaskBits(argFilter.maskBits);
        return builder;
    }

    private Box2D.PbVec2 vecToPb(Vec2 argVec) {
        if (argVec == null) {
            return null;
        }
        return Box2D.PbVec2.newBuilder().setX(argVec.x).setY(argVec.y).build();
    }
}

