/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.framework;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import org.jbox2d.common.Vec2;
import org.jbox2d.testbed.framework.TestbedModel;
import org.jbox2d.testbed.framework.TestbedPanel;
import org.jbox2d.testbed.framework.TestbedTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestbedController
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(TestbedController.class);
    public static final int DEFAULT_FPS = 60;
    private TestbedTest currTest = null;
    private TestbedTest nextTest = null;
    private long startTime;
    private long frameCount;
    private int targetFrameRate;
    private float frameRate = 0.0f;
    private boolean animating = false;
    private Thread animator;
    private final TestbedModel model;
    private final TestbedPanel panel;

    public TestbedController(TestbedModel argModel, TestbedPanel argPanel) {
        this.model = argModel;
        this.setFrameRate(60);
        this.panel = argPanel;
        this.animator = new Thread((Runnable)this, "Testbed");
        this.addListeners();
    }

    private void addListeners() {
        this.model.addTestChangeListener(new TestbedModel.TestChangedListener(){

            @Override
            public void testChanged(TestbedTest argTest, int argIndex) {
                TestbedController.this.nextTest = argTest;
                TestbedController.this.panel.grabFocus();
            }
        });
        this.panel.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                char key = e.getKeyChar();
                int code = e.getKeyCode();
                if (key != '\uffff') {
                    ((TestbedController)TestbedController.this).model.getKeys()[key] = false;
                }
                ((TestbedController)TestbedController.this).model.getCodedKeys()[code] = false;
                if (TestbedController.this.model.getCurrTest() != null) {
                    TestbedController.this.model.getCurrTest().queueKeyReleased(key, code);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                char key = e.getKeyChar();
                int code = e.getKeyCode();
                if (key != '\uffff') {
                    ((TestbedController)TestbedController.this).model.getKeys()[key] = true;
                }
                ((TestbedController)TestbedController.this).model.getCodedKeys()[code] = true;
                if (key == ' ' && TestbedController.this.model.getCurrTest() != null) {
                    TestbedController.this.model.getCurrTest().lanchBomb();
                } else if (key == '[') {
                    TestbedController.this.lastTest();
                } else if (key == ']') {
                    TestbedController.this.nextTest();
                } else if (key == 'r') {
                    TestbedController.this.resetTest();
                } else if (TestbedController.this.model.getCurrTest() != null) {
                    TestbedController.this.model.getCurrTest().queueKeyPressed(key, code);
                }
            }
        });
        this.panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (TestbedController.this.model.getCurrTest() != null) {
                    Vec2 pos = new Vec2(e.getX(), e.getY());
                    TestbedController.this.model.getDebugDraw().getScreenToWorldToOut(pos, pos);
                    TestbedController.this.model.getCurrTest().queueMouseUp(pos);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TestbedController.this.panel.grabFocus();
                if (TestbedController.this.model.getCurrTest() != null) {
                    Vec2 pos = new Vec2(e.getX(), e.getY());
                    if (e.getButton() == 1) {
                        TestbedController.this.model.getDebugDraw().getScreenToWorldToOut(pos, pos);
                        TestbedController.this.model.getCurrTest().queueMouseDown(pos);
                        if (TestbedController.this.model.getCodedKeys()[16]) {
                            TestbedController.this.model.getCurrTest().queueShiftMouseDown(pos);
                        }
                    }
                }
            }
        });
        this.panel.addMouseMotionListener(new MouseMotionListener(){
            final Vec2 posDif = new Vec2();
            final Vec2 pos = new Vec2();
            final Vec2 pos2 = new Vec2();

            @Override
            public void mouseDragged(MouseEvent e) {
                this.pos.set(e.getX(), e.getY());
                if (e.getButton() == 3) {
                    this.posDif.set(TestbedController.this.model.getMouse());
                    TestbedController.this.model.setMouse(this.pos);
                    this.posDif.subLocal(this.pos);
                    TestbedController.this.model.getDebugDraw().getViewportTranform().getScreenVectorToWorld(this.posDif, this.posDif);
                    TestbedController.this.model.getDebugDraw().getViewportTranform().getCenter().addLocal(this.posDif);
                    if (TestbedController.this.model.getCurrTest() != null) {
                        TestbedController.this.model.getCurrTest().setCachedCameraPos(TestbedController.this.model.getDebugDraw().getViewportTranform().getCenter());
                    }
                }
                if (TestbedController.this.model.getCurrTest() != null) {
                    TestbedController.this.model.setMouse(this.pos);
                    TestbedController.this.model.getDebugDraw().getScreenToWorldToOut(this.pos, this.pos);
                    TestbedController.this.model.getCurrTest().queueMouseMove(this.pos);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.pos2.set(e.getX(), e.getY());
                TestbedController.this.model.setMouse(this.pos2);
                if (TestbedController.this.model.getCurrTest() != null) {
                    TestbedController.this.model.getDebugDraw().getScreenToWorldToOut(this.pos2, this.pos2);
                    TestbedController.this.model.getCurrTest().queueMouseMove(this.pos2);
                }
            }
        });
    }

    protected void loopInit() {
        this.panel.grabFocus();
        if (this.currTest != null) {
            this.currTest.init(this.model);
        }
    }

    protected void update() {
        if (this.currTest != null) {
            this.currTest.update();
        }
    }

    public void nextTest() {
        int index = this.model.getCurrTestIndex() + 1;
        index %= this.model.getTestsSize();
        while (!this.model.isTestAt(index) && index < this.model.getTestsSize() - 1) {
            ++index;
        }
        if (this.model.isTestAt(index)) {
            this.model.setCurrTestIndex(index);
        }
    }

    public void resetTest() {
        this.model.getCurrTest().reset();
    }

    public void saveTest() {
        this.model.getCurrTest().save();
    }

    public void loadTest() {
        this.model.getCurrTest().load();
    }

    public void lastTest() {
        int index = this.model.getCurrTestIndex() - 1;
        int n = index = index < 0 ? index + this.model.getTestsSize() : index;
        while (!this.model.isTestAt(index) && index > 0) {
            --index;
        }
        if (this.model.isTestAt(index)) {
            this.model.setCurrTestIndex(index);
        }
    }

    public void playTest(int argIndex) {
        if (argIndex == -1) {
            return;
        }
        while (!this.model.isTestAt(argIndex)) {
            if (argIndex + 1 < this.model.getTestsSize()) {
                ++argIndex;
                continue;
            }
            return;
        }
        this.model.setCurrTestIndex(argIndex);
    }

    public void setFrameRate(int fps) {
        if (fps <= 0) {
            throw new IllegalArgumentException("Fps cannot be less than or equal to zero");
        }
        this.targetFrameRate = fps;
        this.frameRate = fps;
    }

    public int getFrameRate() {
        return this.targetFrameRate;
    }

    public float getCalculatedFrameRate() {
        return this.frameRate;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getFrameCount() {
        return this.frameCount;
    }

    public boolean isAnimating() {
        return this.animating;
    }

    public synchronized void start() {
        if (!this.animating) {
            this.frameCount = 0L;
            this.animator.start();
        } else {
            log.warn("Animation is already animating.");
        }
    }

    public synchronized void stop() {
        this.animating = false;
    }

    @Override
    public void run() {
        long updateTime;
        this.startTime = updateTime = System.nanoTime();
        long beforeTime = updateTime;
        long sleepTime = 0L;
        this.animating = true;
        this.loopInit();
        while (this.animating) {
            long timeSpent;
            if (this.nextTest != null) {
                if (this.currTest != null) {
                    this.currTest.exit();
                }
                this.currTest = this.nextTest;
                this.currTest.init(this.model);
                this.nextTest = null;
            }
            if ((timeSpent = beforeTime - updateTime) > 0L) {
                float timeInSecs = (float)timeSpent * 1.0f / 1.0E9f;
                updateTime = System.nanoTime();
                this.frameRate = this.frameRate * 0.9f + 1.0f / timeInSecs * 0.1f;
                this.model.setCalculatedFps(this.frameRate);
            } else {
                updateTime = System.nanoTime();
            }
            if (this.panel.render()) {
                this.update();
                this.panel.paintScreen();
            }
            ++this.frameCount;
            long afterTime = System.nanoTime();
            long timeDiff = afterTime - beforeTime;
            sleepTime = ((long)(1000000000 / this.targetFrameRate) - timeDiff) / 1000000L;
            if (sleepTime > 0L) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            beforeTime = System.nanoTime();
        }
    }
}

