/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.framework;

import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.common.Vec2;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class TestbedModel {
    private final DefaultComboBoxModel tests = new DefaultComboBoxModel();
    private final TestbedSettings settings = new TestbedSettings();
    private DebugDraw draw;
    private TestbedTest test;
    private final Vec2 mouse = new Vec2();
    private final Vector<TestChangedListener> listeners = new Vector();
    private final boolean[] keys = new boolean[512];
    private final boolean[] codedKeys = new boolean[512];
    private float calculatedFps;
    private float panelWidth;
    private int currTestIndex;

    public void setCalculatedFps(float calculatedFps) {
        this.calculatedFps = calculatedFps;
    }

    public float getCalculatedFps() {
        return this.calculatedFps;
    }

    public void setPanelWidth(float panelWidth) {
        this.panelWidth = panelWidth;
    }

    public float getPanelWidth() {
        return this.panelWidth;
    }

    public void setDebugDraw(DebugDraw argDraw) {
        this.draw = argDraw;
    }

    public DebugDraw getDebugDraw() {
        return this.draw;
    }

    public TestbedTest getCurrTest() {
        return this.test;
    }

    public Vec2 getMouse() {
        return this.mouse;
    }

    public void setMouse(Vec2 argMouse) {
        this.mouse.set(argMouse);
    }

    public boolean[] getKeys() {
        return this.keys;
    }

    public boolean[] getCodedKeys() {
        return this.codedKeys;
    }

    public void setCurrTestIndex(int argCurrTestIndex) {
        if (argCurrTestIndex < 0 || argCurrTestIndex >= this.tests.getSize()) {
            throw new IllegalArgumentException("Invalid test index");
        }
        if (this.currTestIndex == argCurrTestIndex) {
            return;
        }
        if (!this.isTestAt(argCurrTestIndex)) {
            throw new IllegalArgumentException("No test at " + argCurrTestIndex);
        }
        this.currTestIndex = argCurrTestIndex;
        ListItem item = (ListItem)this.tests.getElementAt(argCurrTestIndex);
        this.test = item.test;
        for (TestChangedListener listener : this.listeners) {
            listener.testChanged(this.test, this.currTestIndex);
        }
    }

    public int getCurrTestIndex() {
        return this.currTestIndex;
    }

    public void addTestChangeListener(TestChangedListener argListener) {
        this.listeners.add(argListener);
    }

    public void removeTestChangeListener(TestChangedListener argListener) {
        this.listeners.remove(argListener);
    }

    public void addTest(TestbedTest argTest) {
        this.tests.addElement(new ListItem(argTest));
    }

    public void addCategory(String argName) {
        this.tests.addElement(new ListItem(argName));
    }

    public TestbedTest getTestAt(int argIndex) {
        ListItem item = (ListItem)this.tests.getElementAt(argIndex);
        if (item.isCategory()) {
            return null;
        }
        return item.test;
    }

    public boolean isTestAt(int argIndex) {
        ListItem item = (ListItem)this.tests.getElementAt(argIndex);
        return !item.isCategory();
    }

    public void clearTestList() {
        this.tests.removeAllElements();
    }

    public int getTestsSize() {
        return this.tests.getSize();
    }

    public DefaultComboBoxModel getComboModel() {
        return this.tests;
    }

    public TestbedSettings getSettings() {
        return this.settings;
    }

    public static interface TestChangedListener {
        public void testChanged(TestbedTest var1, int var2);
    }

    public class ListItem {
        public String category;
        public TestbedTest test;

        public ListItem(String argCategory) {
            this.category = argCategory;
        }

        public ListItem(TestbedTest argTest) {
            this.test = argTest;
        }

        public boolean isCategory() {
            return this.category != null;
        }

        public String toString() {
            return this.isCategory() ? this.category : this.test.getTestName();
        }
    }
}

