/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.framework;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jbox2d.testbed.framework.TestbedSetting;

public class TestbedSettings {
    public static final String Hz = "Hz";
    public static final String PositionIterations = "Pos Iters";
    public static final String VelocityIterations = "Vel Iters";
    public static final String WarmStarting = "Warm Starting";
    public static final String ContinuousCollision = "Continuous Collision";
    public static final String DrawShapes = "Draw Shapes";
    public static final String DrawJoints = "Draw Joints";
    public static final String DrawAABBs = "Draw AABBs";
    public static final String DrawPairs = "Draw Pairs";
    public static final String DrawContactPoints = "Draw Contact Points";
    public static final String DrawNormals = "Draw Normals";
    public static final String DrawCOMs = "Draw Center of Mass";
    public static final String DrawStats = "Draw Stats";
    public static final String DrawHelp = "Draw Help";
    public static final String DrawTree = "Draw Dynamic Tree";
    public boolean pause = false;
    public boolean singleStep = false;
    private ArrayList<TestbedSetting> settings = new ArrayList();
    private final HashMap<String, TestbedSetting> settingsMap = new HashMap();

    public TestbedSettings() {
        this.populateDefaultSettings();
    }

    private void populateDefaultSettings() {
        this.addSetting(new TestbedSetting(Hz, TestbedSetting.SettingType.ENGINE, 60, 1, 400));
        this.addSetting(new TestbedSetting(PositionIterations, TestbedSetting.SettingType.ENGINE, 3, 0, 100));
        this.addSetting(new TestbedSetting(VelocityIterations, TestbedSetting.SettingType.ENGINE, 8, 1, 100));
        this.addSetting(new TestbedSetting(WarmStarting, TestbedSetting.SettingType.ENGINE, true));
        this.addSetting(new TestbedSetting(ContinuousCollision, TestbedSetting.SettingType.ENGINE, true));
        this.addSetting(new TestbedSetting(DrawShapes, TestbedSetting.SettingType.DRAWING, true));
        this.addSetting(new TestbedSetting(DrawJoints, TestbedSetting.SettingType.DRAWING, true));
        this.addSetting(new TestbedSetting(DrawAABBs, TestbedSetting.SettingType.DRAWING, false));
        this.addSetting(new TestbedSetting(DrawPairs, TestbedSetting.SettingType.DRAWING, false));
        this.addSetting(new TestbedSetting(DrawContactPoints, TestbedSetting.SettingType.DRAWING, false));
        this.addSetting(new TestbedSetting(DrawNormals, TestbedSetting.SettingType.DRAWING, false));
        this.addSetting(new TestbedSetting(DrawCOMs, TestbedSetting.SettingType.DRAWING, false));
        this.addSetting(new TestbedSetting(DrawStats, TestbedSetting.SettingType.DRAWING, true));
        this.addSetting(new TestbedSetting(DrawHelp, TestbedSetting.SettingType.DRAWING, false));
        this.addSetting(new TestbedSetting(DrawTree, TestbedSetting.SettingType.DRAWING, false));
    }

    public void addSetting(TestbedSetting argSetting) {
        if (this.settingsMap.containsKey(argSetting.name)) {
            throw new IllegalArgumentException("Settings already contain a setting with name: " + argSetting.name);
        }
        this.settings.add(argSetting);
        this.settingsMap.put(argSetting.name, argSetting);
    }

    public List<TestbedSetting> getSettings() {
        return Collections.unmodifiableList(this.settings);
    }

    public TestbedSetting getSetting(String argName) {
        return this.settingsMap.get(argName);
    }
}

