/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.framework;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.jbox2d.callbacks.ContactImpulse;
import org.jbox2d.callbacks.ContactListener;
import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.callbacks.DestructionListener;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.Collision;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.WorldManifold;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.MouseJoint;
import org.jbox2d.dynamics.joints.MouseJointDef;
import org.jbox2d.serialization.JbDeserializer;
import org.jbox2d.serialization.JbSerializer;
import org.jbox2d.serialization.SerializationResult;
import org.jbox2d.serialization.UnsupportedListener;
import org.jbox2d.serialization.UnsupportedObjectException;
import org.jbox2d.serialization.pb.PbDeserializer;
import org.jbox2d.serialization.pb.PbSerializer;
import org.jbox2d.testbed.framework.ContactPoint;
import org.jbox2d.testbed.framework.ListenerAdapter;
import org.jbox2d.testbed.framework.QueueItem;
import org.jbox2d.testbed.framework.QueueItemType;
import org.jbox2d.testbed.framework.SignerAdapter;
import org.jbox2d.testbed.framework.TestQueryCallback;
import org.jbox2d.testbed.framework.TestbedModel;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestbedTest
implements ContactListener,
JbDeserializer.ObjectListener,
JbSerializer.ObjectSigner,
UnsupportedListener {
    public static final int MAX_CONTACT_POINTS = 2048;
    protected static final long GROUND_BODY_TAG = 1897450239847L;
    protected static final long BOMB_TAG = 98989788987L;
    protected static final long MOUSE_JOINT_TAG = 4567893364789L;
    private static final Logger log = LoggerFactory.getLogger(TestbedTest.class);
    public static final ContactPoint[] points = new ContactPoint[2048];
    protected World m_world;
    private Body groundBody;
    private MouseJoint mouseJoint;
    private Body bomb;
    private final Vec2 bombSpawnPoint = new Vec2();
    private boolean bombSpawning = false;
    private final Vec2 mouseWorld = new Vec2();
    private int pointCount;
    private int stepCount;
    private TestbedModel model;
    private DestructionListener destructionListener;
    private final LinkedList<QueueItem> inputQueue;
    private String title = null;
    protected int m_textLine;
    private final LinkedList<String> textList = new LinkedList();
    private float cachedCameraScale;
    private final Vec2 cachedCameraPos = new Vec2();
    private boolean hasCachedCamera = false;
    private JbSerializer serializer;
    private JbDeserializer deserializer;
    private boolean dialogOnSaveLoadErrors = true;
    private boolean savePending;
    private boolean loadPending;
    private boolean resetPending = false;
    private final Color3f color1 = new Color3f(0.3f, 0.95f, 0.3f);
    private final Color3f color2 = new Color3f(0.3f, 0.3f, 0.95f);
    private final Color3f color3 = new Color3f(0.9f, 0.9f, 0.9f);
    private final Color3f color4 = new Color3f(0.6f, 0.61f, 1.0f);
    private final Color3f mouseColor = new Color3f(0.0f, 1.0f, 0.0f);
    private final Vec2 p1 = new Vec2();
    private final Vec2 p2 = new Vec2();
    private final AABB queryAABB = new AABB();
    private final TestQueryCallback callback = new TestQueryCallback();
    private final Vec2 p = new Vec2();
    private final Vec2 v = new Vec2();
    private final AABB aabb = new AABB();
    private final Vec2 vel = new Vec2();
    private final Collision.PointState[] state1 = new Collision.PointState[Settings.maxManifoldPoints];
    private final Collision.PointState[] state2 = new Collision.PointState[Settings.maxManifoldPoints];
    private final WorldManifold worldManifold = new WorldManifold();

    public TestbedTest() {
        this.inputQueue = new LinkedList();
        this.serializer = new PbSerializer(this, new SignerAdapter(this){

            @Override
            public Long getTag(Body argBody) {
                if (TestbedTest.this.isSaveLoadEnabled()) {
                    if (argBody == TestbedTest.this.groundBody) {
                        return 1897450239847L;
                    }
                    if (argBody == TestbedTest.this.bomb) {
                        return 98989788987L;
                    }
                }
                return super.getTag(argBody);
            }

            @Override
            public Long getTag(Joint argJoint) {
                if (TestbedTest.this.isSaveLoadEnabled() && argJoint == TestbedTest.this.mouseJoint) {
                    return 4567893364789L;
                }
                return super.getTag(argJoint);
            }
        });
        this.deserializer = new PbDeserializer(this, new ListenerAdapter(this){

            @Override
            public void processBody(Body argBody, Long argTag) {
                if (TestbedTest.this.isSaveLoadEnabled()) {
                    if (argTag == 1897450239847L) {
                        TestbedTest.this.groundBody = argBody;
                        return;
                    }
                    if (argTag == 98989788987L) {
                        TestbedTest.this.bomb = argBody;
                        return;
                    }
                }
                super.processBody(argBody, argTag);
            }

            @Override
            public void processJoint(Joint argJoint, Long argTag) {
                if (TestbedTest.this.isSaveLoadEnabled() && argTag == 4567893364789L) {
                    TestbedTest.this.mouseJoint = (MouseJoint)argJoint;
                    return;
                }
                super.processJoint(argJoint, argTag);
            }
        });
    }

    public void init(TestbedModel argModel) {
        this.model = argModel;
        this.destructionListener = new DestructionListener(){

            @Override
            public void sayGoodbye(Fixture fixture) {
            }

            @Override
            public void sayGoodbye(Joint joint) {
                if (TestbedTest.this.mouseJoint == joint) {
                    TestbedTest.this.mouseJoint = null;
                } else {
                    TestbedTest.this.jointDestroyed(joint);
                }
            }
        };
        Vec2 gravity = new Vec2(0.0f, -10.0f);
        this.m_world = new World(gravity, true);
        this.bomb = null;
        this.mouseJoint = null;
        BodyDef bodyDef = new BodyDef();
        this.groundBody = this.m_world.createBody(bodyDef);
        this.init(this.m_world, false);
    }

    public void init(World argWorld, boolean argDeserialized) {
        this.pointCount = 0;
        this.stepCount = 0;
        this.bombSpawning = false;
        argWorld.setDestructionListener(this.destructionListener);
        argWorld.setContactListener(this);
        argWorld.setDebugDraw(this.model.getDebugDraw());
        if (this.hasCachedCamera) {
            this.setCamera(this.cachedCameraPos, this.cachedCameraScale);
        } else {
            this.setCamera(this.getDefaultCameraPos(), this.getDefaultCameraScale());
        }
        this.setTitle(this.getTestName());
        this.initTest(argDeserialized);
    }

    public World getWorld() {
        return this.m_world;
    }

    public TestbedModel getModel() {
        return this.model;
    }

    public static ContactPoint[] getContactPoints() {
        return points;
    }

    public Body getGroundBody() {
        return this.groundBody;
    }

    public DebugDraw getDebugDraw() {
        return this.model.getDebugDraw();
    }

    public Vec2 getWorldMouse() {
        return this.mouseWorld;
    }

    public int getStepCount() {
        return this.stepCount;
    }

    public int getPointCount() {
        return this.pointCount;
    }

    public Body getBomb() {
        return this.bomb;
    }

    public float getCachedCameraScale() {
        return this.cachedCameraScale;
    }

    public void setCachedCameraScale(float cachedCameraScale) {
        this.cachedCameraScale = cachedCameraScale;
    }

    public Vec2 getCachedCameraPos() {
        return this.cachedCameraPos;
    }

    public void setCachedCameraPos(Vec2 argPos) {
        this.cachedCameraPos.set(argPos);
    }

    public boolean isHasCachedCamera() {
        return this.hasCachedCamera;
    }

    public void setHasCachedCamera(boolean hasCachedCamera) {
        this.hasCachedCamera = hasCachedCamera;
    }

    public boolean isDialogOnSaveLoadErrors() {
        return this.dialogOnSaveLoadErrors;
    }

    public void setDialogOnSaveLoadErrors(boolean dialogOnSaveLoadErrors) {
        this.dialogOnSaveLoadErrors = dialogOnSaveLoadErrors;
    }

    public Vec2 getDefaultCameraPos() {
        return new Vec2(0.0f, 10.0f);
    }

    public float getDefaultCameraScale() {
        return 10.0f;
    }

    public String getFilename() {
        return this.getTestName().toLowerCase().replaceAll(" ", "_") + ".box2d";
    }

    public void reset() {
        this.resetPending = true;
    }

    public void save() {
        this.savePending = true;
    }

    public void load() {
        this.loadPending = true;
    }

    protected void _reset() {
        this.init(this.model);
    }

    protected void _save() {
        SerializationResult result;
        try {
            result = this.serializer.serialize(this.m_world);
        }
        catch (UnsupportedObjectException e1) {
            log.error("Error serializing world", e1);
            if (this.dialogOnSaveLoadErrors) {
                JOptionPane.showConfirmDialog(null, "Error serializing the object: " + e1.toString(), "Serialization Error", 0);
            }
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.getFilename());
            result.writeTo(fos);
        }
        catch (FileNotFoundException e) {
            log.error("File not found exception while saving", e);
            if (this.dialogOnSaveLoadErrors) {
                JOptionPane.showConfirmDialog(null, "File not found exception while saving: " + this.getFilename(), "Serialization Error", 0);
            }
            return;
        }
        catch (IOException e) {
            log.error("Exception while writing world", e);
            if (this.dialogOnSaveLoadErrors) {
                JOptionPane.showConfirmDialog(null, "Error while writing world: " + e.toString(), "Serialization Error", 0);
            }
            return;
        }
    }

    protected void _load() {
        World w;
        try {
            FileInputStream fis = new FileInputStream(this.getFilename());
            w = this.deserializer.deserializeWorld(fis);
        }
        catch (FileNotFoundException e) {
            log.error("File not found error while loading", e);
            if (this.dialogOnSaveLoadErrors) {
                JOptionPane.showMessageDialog(null, "File not found exception while loading: " + this.getFilename(), "Serialization Error", 0);
            }
            return;
        }
        catch (UnsupportedObjectException e) {
            log.error("Error deserializing world", e);
            if (this.dialogOnSaveLoadErrors) {
                JOptionPane.showMessageDialog(null, "Error serializing the object: " + e.toString(), "Serialization Error", 0);
            }
            return;
        }
        catch (IOException e) {
            log.error("Exception while writing world", e);
            if (this.dialogOnSaveLoadErrors) {
                JOptionPane.showMessageDialog(null, "Error while reading world: " + e.toString(), "Serialization Error", 0);
            }
            return;
        }
        this.m_world = w;
        this.init(this.m_world, true);
    }

    public void setCamera(Vec2 argPos, float scale) {
        this.model.getDebugDraw().setCamera(argPos.x, argPos.y, scale);
        this.hasCachedCamera = true;
        this.cachedCameraScale = scale;
        this.cachedCameraPos.set(argPos);
    }

    public abstract void initTest(boolean var1);

    public abstract String getTestName();

    public void exit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        if (this.resetPending) {
            this._reset();
            this.resetPending = false;
        }
        if (this.savePending) {
            this._save();
            this.savePending = false;
        }
        if (this.loadPending) {
            this._load();
            this.loadPending = false;
        }
        this.m_textLine = 30;
        if (this.title != null) {
            this.model.getDebugDraw().drawString(this.model.getPanelWidth() / 2.0f, 15.0f, this.title, Color3f.WHITE);
        }
        if (!this.inputQueue.isEmpty()) {
            LinkedList<QueueItem> linkedList = this.inputQueue;
            synchronized (linkedList) {
                while (!this.inputQueue.isEmpty()) {
                    QueueItem i = this.inputQueue.pop();
                    switch (i.type) {
                        case KeyPressed: {
                            this.keyPressed(i.c, i.code);
                            break;
                        }
                        case KeyReleased: {
                            this.keyReleased(i.c, i.code);
                            break;
                        }
                        case MouseDown: {
                            this.mouseDown(i.p);
                            break;
                        }
                        case MouseMove: {
                            this.mouseMove(i.p);
                            break;
                        }
                        case MouseUp: {
                            this.mouseUp(i.p);
                            break;
                        }
                        case ShiftMouseDown: {
                            this.shiftMouseDown(i.p);
                        }
                    }
                }
            }
        }
        this.step(this.model.getSettings());
    }

    public synchronized void step(TestbedSettings settings) {
        float timeStep;
        float hz = settings.getSetting((String)"Hz").value;
        float f = timeStep = hz > 0.0f ? 1.0f / hz : 0.0f;
        if (settings.singleStep && !settings.pause) {
            settings.pause = true;
        }
        if (settings.pause) {
            if (settings.singleStep) {
                settings.singleStep = false;
            } else {
                timeStep = 0.0f;
            }
            this.model.getDebugDraw().drawString(5.0f, this.m_textLine, "****PAUSED****", Color3f.WHITE);
            this.m_textLine += 15;
        }
        int flags = 0;
        this.model.getDebugDraw();
        flags += settings.getSetting((String)"Draw Shapes").enabled ? 1 : 0;
        flags += settings.getSetting((String)"Draw Joints").enabled ? 2 : 0;
        flags += settings.getSetting((String)"Draw AABBs").enabled ? 4 : 0;
        flags += settings.getSetting((String)"Draw Pairs").enabled ? 8 : 0;
        flags += settings.getSetting((String)"Draw Center of Mass").enabled ? 16 : 0;
        this.model.getDebugDraw().setFlags(flags += settings.getSetting((String)"Draw Dynamic Tree").enabled ? 32 : 0);
        this.m_world.setWarmStarting(settings.getSetting((String)"Warm Starting").enabled);
        this.m_world.setContinuousPhysics(settings.getSetting((String)"Continuous Collision").enabled);
        this.pointCount = 0;
        this.m_world.step(timeStep, settings.getSetting((String)"Vel Iters").value, settings.getSetting((String)"Pos Iters").value);
        this.m_world.drawDebugData();
        if (timeStep > 0.0f) {
            ++this.stepCount;
        }
        if (settings.getSetting((String)"Draw Stats").enabled) {
            this.model.getDebugDraw().drawString(5.0f, this.m_textLine, "Engine Info", this.color4);
            this.m_textLine += 15;
            this.model.getDebugDraw().drawString(5.0f, this.m_textLine, "Framerate: " + this.model.getCalculatedFps(), Color3f.WHITE);
            this.m_textLine += 15;
            this.model.getDebugDraw().drawString(5.0f, this.m_textLine, "bodies/contacts/joints/proxies = " + this.m_world.getBodyCount() + "/" + this.m_world.getContactCount() + "/" + this.m_world.getJointCount() + "/" + this.m_world.getProxyCount(), Color3f.WHITE);
            this.m_textLine += 20;
        }
        if (settings.getSetting((String)"Draw Help").enabled) {
            this.model.getDebugDraw().drawString(5.0f, this.m_textLine, "Help", this.color4);
            this.m_textLine += 15;
            this.model.getDebugDraw().drawString(5.0f, this.m_textLine, "Click and drag the left mouse button to move objects.", Color3f.WHITE);
            this.m_textLine += 15;
            this.model.getDebugDraw().drawString(5.0f, this.m_textLine, "Shift-Click to aim a bullet, or press space.", Color3f.WHITE);
            this.m_textLine += 15;
            this.model.getDebugDraw().drawString(5.0f, this.m_textLine, "Click and drag the right mouse button to move the view.", Color3f.WHITE);
            this.m_textLine += 15;
            this.model.getDebugDraw().drawString(5.0f, this.m_textLine, "Scroll to zoom in/out.", Color3f.WHITE);
            this.m_textLine += 15;
            this.model.getDebugDraw().drawString(5.0f, this.m_textLine, "Press '[' or ']' to change tests, and 'r' to restart.", Color3f.WHITE);
            this.m_textLine += 20;
        }
        if (!this.textList.isEmpty()) {
            this.model.getDebugDraw().drawString(5.0f, this.m_textLine, "Test Info", this.color4);
            this.m_textLine += 15;
            for (String s : this.textList) {
                this.model.getDebugDraw().drawString(5.0f, this.m_textLine, s, Color3f.WHITE);
                this.m_textLine += 15;
            }
            this.textList.clear();
        }
        if (this.mouseJoint != null) {
            this.mouseJoint.getAnchorB(this.p1);
            Vec2 p2 = this.mouseJoint.getTarget();
            this.model.getDebugDraw().drawSegment(this.p1, p2, this.mouseColor);
        }
        if (this.bombSpawning) {
            this.model.getDebugDraw().drawSegment(this.bombSpawnPoint, this.mouseWorld, Color3f.WHITE);
        }
        if (settings.getSetting((String)"Draw Contact Points").enabled) {
            float axisScale = 0.3f;
            for (int i = 0; i < this.pointCount; ++i) {
                ContactPoint point = points[i];
                if (point.state == Collision.PointState.ADD_STATE) {
                    this.model.getDebugDraw().drawPoint(point.position, 10.0f, this.color1);
                } else if (point.state == Collision.PointState.PERSIST_STATE) {
                    this.model.getDebugDraw().drawPoint(point.position, 5.0f, this.color2);
                }
                if (!settings.getSetting((String)"Draw Normals").enabled) continue;
                this.p1.set(point.position);
                this.p2.set(point.normal).mulLocal(0.3f).addLocal(this.p1);
                this.model.getDebugDraw().drawSegment(this.p1, this.p2, this.color3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueShiftMouseDown(Vec2 p) {
        LinkedList<QueueItem> linkedList = this.inputQueue;
        synchronized (linkedList) {
            this.inputQueue.addLast(new QueueItem(QueueItemType.ShiftMouseDown, p));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMouseUp(Vec2 p) {
        LinkedList<QueueItem> linkedList = this.inputQueue;
        synchronized (linkedList) {
            this.inputQueue.addLast(new QueueItem(QueueItemType.MouseUp, p));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMouseDown(Vec2 p) {
        LinkedList<QueueItem> linkedList = this.inputQueue;
        synchronized (linkedList) {
            this.inputQueue.addLast(new QueueItem(QueueItemType.MouseDown, p));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMouseMove(Vec2 p) {
        LinkedList<QueueItem> linkedList = this.inputQueue;
        synchronized (linkedList) {
            this.inputQueue.addLast(new QueueItem(QueueItemType.MouseMove, p));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueKeyPressed(char c, int code) {
        LinkedList<QueueItem> linkedList = this.inputQueue;
        synchronized (linkedList) {
            this.inputQueue.addLast(new QueueItem(QueueItemType.KeyPressed, c, code));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueKeyReleased(char c, int code) {
        LinkedList<QueueItem> linkedList = this.inputQueue;
        synchronized (linkedList) {
            this.inputQueue.addLast(new QueueItem(QueueItemType.KeyReleased, c, code));
        }
    }

    public void shiftMouseDown(Vec2 p) {
        this.mouseWorld.set(p);
        if (this.mouseJoint != null) {
            return;
        }
        this.spawnBomb(p);
    }

    public void mouseUp(Vec2 p) {
        if (this.mouseJoint != null) {
            this.m_world.destroyJoint(this.mouseJoint);
            this.mouseJoint = null;
        }
        if (this.bombSpawning) {
            this.completeBombSpawn(p);
        }
    }

    public void mouseDown(Vec2 p) {
        this.mouseWorld.set(p);
        if (this.mouseJoint != null) {
            return;
        }
        this.queryAABB.lowerBound.set(p.x - 0.001f, p.y - 0.001f);
        this.queryAABB.upperBound.set(p.x + 0.001f, p.y + 0.001f);
        this.callback.point.set(p);
        this.callback.fixture = null;
        this.m_world.queryAABB(this.callback, this.queryAABB);
        if (this.callback.fixture != null) {
            Body body = this.callback.fixture.getBody();
            MouseJointDef def = new MouseJointDef();
            def.bodyA = this.groundBody;
            def.bodyB = body;
            def.target.set(p);
            def.maxForce = 1000.0f * body.getMass();
            this.mouseJoint = (MouseJoint)this.m_world.createJoint(def);
            body.setAwake(true);
        }
    }

    public void mouseMove(Vec2 p) {
        this.mouseWorld.set(p);
        if (this.mouseJoint != null) {
            this.mouseJoint.setTarget(p);
        }
    }

    public void setTitle(String argTitle) {
        this.title = argTitle;
    }

    public void addTextLine(String argTextLine) {
        this.textList.add(argTextLine);
    }

    public void lanchBomb() {
        this.p.set((float)(Math.random() * 30.0 - 15.0), 30.0f);
        this.v.set(this.p).mulLocal(-5.0f);
        this.launchBomb(this.p, this.v);
    }

    public synchronized void launchBomb(Vec2 position, Vec2 velocity) {
        if (this.bomb != null) {
            this.m_world.destroyBody(this.bomb);
            this.bomb = null;
        }
        BodyDef bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        bd.position.set(position);
        bd.bullet = true;
        this.bomb = this.m_world.createBody(bd);
        this.bomb.setLinearVelocity(velocity);
        CircleShape circle = new CircleShape();
        circle.m_radius = 0.3f;
        FixtureDef fd = new FixtureDef();
        fd.shape = circle;
        fd.density = 20.0f;
        fd.restitution = 0.0f;
        Vec2 minV = new Vec2(position);
        Vec2 maxV = new Vec2(position);
        minV.subLocal(new Vec2(0.3f, 0.3f));
        maxV.addLocal(new Vec2(0.3f, 0.3f));
        this.aabb.lowerBound.set(minV);
        this.aabb.upperBound.set(maxV);
        this.bomb.createFixture(fd);
    }

    public synchronized void spawnBomb(Vec2 worldPt) {
        this.bombSpawnPoint.set(worldPt);
        this.bombSpawning = true;
    }

    public synchronized void completeBombSpawn(Vec2 p) {
        if (!this.bombSpawning) {
            return;
        }
        float multiplier = 30.0f;
        this.vel.set(this.bombSpawnPoint).subLocal(p);
        this.vel.mulLocal(multiplier);
        this.launchBomb(this.bombSpawnPoint, this.vel);
        this.bombSpawning = false;
    }

    public boolean isSaveLoadEnabled() {
        return false;
    }

    @Override
    public Long getTag(Body argBody) {
        return null;
    }

    @Override
    public Long getTag(Fixture argFixture) {
        return null;
    }

    @Override
    public Long getTag(Joint argJoint) {
        return null;
    }

    @Override
    public Long getTag(Shape argShape) {
        return null;
    }

    @Override
    public Long getTag(World argWorld) {
        return null;
    }

    @Override
    public void processBody(Body argBody, Long argTag) {
    }

    @Override
    public void processFixture(Fixture argFixture, Long argTag) {
    }

    @Override
    public void processJoint(Joint argJoint, Long argTag) {
    }

    @Override
    public void processShape(Shape argShape, Long argTag) {
    }

    @Override
    public void processWorld(World argWorld, Long argTag) {
    }

    @Override
    public boolean isUnsupported(UnsupportedObjectException argException) {
        return true;
    }

    public void jointDestroyed(Joint joint) {
    }

    @Override
    public void beginContact(Contact contact) {
    }

    @Override
    public void endContact(Contact contact) {
    }

    @Override
    public void postSolve(Contact contact, ContactImpulse impulse) {
    }

    @Override
    public void preSolve(Contact contact, Manifold oldManifold) {
        Manifold manifold = contact.getManifold();
        if (manifold.pointCount == 0) {
            return;
        }
        Fixture fixtureA = contact.getFixtureA();
        Fixture fixtureB = contact.getFixtureB();
        Collision.getPointStates(this.state1, this.state2, oldManifold, manifold);
        contact.getWorldManifold(this.worldManifold);
        for (int i = 0; i < manifold.pointCount && this.pointCount < 2048; ++i) {
            ContactPoint cp = points[this.pointCount];
            cp.fixtureA = fixtureA;
            cp.fixtureB = fixtureB;
            cp.position.set(this.worldManifold.points[i]);
            cp.normal.set(this.worldManifold.normal);
            cp.state = this.state2[i];
            ++this.pointCount;
        }
    }

    public void keyPressed(char argKeyChar, int argKeyCode) {
    }

    public void keyReleased(char argKeyChar, int argKeyCode) {
    }

    static {
        for (int i = 0; i < 2048; ++i) {
            TestbedTest.points[i] = new ContactPoint();
        }
    }
}

