/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.framework.j2d;

import java.awt.Color;
import java.awt.Graphics2D;
import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.collision.AABB;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.OBBViewportTransform;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.pooling.arrays.IntArray;
import org.jbox2d.pooling.arrays.Vec2Array;
import org.jbox2d.testbed.framework.j2d.TestPanelJ2D;
import org.jbox2d.testbed.pooling.ColorPool;

public class DebugDrawJ2D
extends DebugDraw {
    public static int circlePoints = 13;
    private final TestPanelJ2D panel;
    private final ColorPool cpool = new ColorPool();
    private final Vec2Array vec2Array = new Vec2Array();
    private final Vec2 sp1 = new Vec2();
    private final Vec2 sp2 = new Vec2();
    private final Vec2 saxis = new Vec2();
    private final Vec2 temp = new Vec2();
    private static final IntArray xIntsPool = new IntArray();
    private static final IntArray yIntsPool = new IntArray();
    private final Vec2 temp2 = new Vec2();

    public DebugDrawJ2D(TestPanelJ2D argTestPanel) {
        super(new OBBViewportTransform());
        this.viewportTransform.setYFlip(true);
        this.panel = argTestPanel;
    }

    @Override
    public void drawCircle(Vec2 center, float radius, Color3f color) {
        Vec2[] vecs = this.vec2Array.get(circlePoints);
        this.generateCirle(center, radius, vecs, circlePoints);
        this.drawPolygon(vecs, circlePoints, color);
    }

    @Override
    public void drawPoint(Vec2 argPoint, float argRadiusOnScreen, Color3f argColor) {
        this.getWorldToScreenToOut(argPoint, this.sp1);
        Graphics2D g = this.getGraphics();
        Color c = this.cpool.getColor(argColor.x, argColor.y, argColor.z);
        g.setColor(c);
        this.sp1.x -= argRadiusOnScreen;
        this.sp1.y -= argRadiusOnScreen;
        g.fillOval((int)this.sp1.x, (int)this.sp1.y, (int)argRadiusOnScreen * 2, (int)argRadiusOnScreen * 2);
    }

    @Override
    public void drawSegment(Vec2 p1, Vec2 p2, Color3f color) {
        this.getWorldToScreenToOut(p1, this.sp1);
        this.getWorldToScreenToOut(p2, this.sp2);
        Graphics2D g = this.getGraphics();
        Color c = this.cpool.getColor(color.x, color.y, color.z);
        g.setColor(c);
        g.drawLine((int)this.sp1.x, (int)this.sp1.y, (int)this.sp2.x, (int)this.sp2.y);
    }

    public void drawAABB(AABB argAABB, Color3f color) {
        Vec2[] vecs = this.vec2Array.get(4);
        argAABB.getVertices(vecs);
        this.drawPolygon(vecs, 4, color);
    }

    @Override
    public void drawSolidCircle(Vec2 center, float radius, Vec2 axis, Color3f color) {
        Vec2[] vecs = this.vec2Array.get(circlePoints);
        this.generateCirle(center, radius, vecs, circlePoints);
        this.drawSolidPolygon(vecs, circlePoints, color);
        if (axis != null) {
            this.saxis.set(axis).mulLocal(radius).addLocal(center);
            this.drawSegment(center, this.saxis, color);
        }
    }

    @Override
    public void drawSolidPolygon(Vec2[] vertices, int vertexCount, Color3f color) {
        Graphics2D g = this.getGraphics();
        int[] xInts = xIntsPool.get(vertexCount);
        int[] yInts = yIntsPool.get(vertexCount);
        for (int i = 0; i < vertexCount; ++i) {
            this.getWorldToScreenToOut(vertices[i], this.temp);
            xInts[i] = (int)this.temp.x;
            yInts[i] = (int)this.temp.y;
        }
        Color c = this.cpool.getColor(color.x, color.y, color.z, 0.4f);
        g.setColor(c);
        g.fillPolygon(xInts, yInts, vertexCount);
        this.drawPolygon(vertices, vertexCount, color);
    }

    @Override
    public void drawString(float x, float y, String s, Color3f color) {
        Graphics2D g = this.getGraphics();
        Color c = this.cpool.getColor(color.x, color.y, color.z);
        g.setColor(c);
        g.drawString(s, x, y);
    }

    private Graphics2D getGraphics() {
        return this.panel.getDBGraphics();
    }

    @Override
    public void drawTransform(Transform xf) {
        Graphics2D g = this.getGraphics();
        this.getWorldToScreenToOut(xf.position, this.temp);
        this.temp2.setZero();
        float k_axisScale = 0.4f;
        Color c = this.cpool.getColor(1.0f, 0.0f, 0.0f);
        g.setColor(c);
        this.temp2.x = xf.position.x + k_axisScale * xf.R.col1.x;
        this.temp2.y = xf.position.y + k_axisScale * xf.R.col1.y;
        this.getWorldToScreenToOut(this.temp2, this.temp2);
        g.drawLine((int)this.temp.x, (int)this.temp.y, (int)this.temp2.x, (int)this.temp2.y);
        c = this.cpool.getColor(0.0f, 1.0f, 0.0f);
        g.setColor(c);
        this.temp2.x = xf.position.x + k_axisScale * xf.R.col2.x;
        this.temp2.y = xf.position.y + k_axisScale * xf.R.col2.y;
        this.getWorldToScreenToOut(this.temp2, this.temp2);
        g.drawLine((int)this.temp.x, (int)this.temp.y, (int)this.temp2.x, (int)this.temp2.y);
    }

    private void generateCirle(Vec2 argCenter, float argRadius, Vec2[] argPoints, int argNumPoints) {
        float inc = (float)Math.PI * 2 / (float)argNumPoints;
        for (int i = 0; i < argNumPoints; ++i) {
            argPoints[i].x = argCenter.x + MathUtils.cos((float)i * inc) * argRadius;
            argPoints[i].y = argCenter.y + MathUtils.sin((float)i * inc) * argRadius;
        }
    }
}

