/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import java.util.Random;
import org.jbox2d.callbacks.TreeCallback;
import org.jbox2d.callbacks.TreeRayCastCallback;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.RayCastOutput;
import org.jbox2d.collision.broadphase.DynamicTree;
import org.jbox2d.collision.broadphase.DynamicTreeNode;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.pooling.arrays.Vec2Array;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class DynamicTreeTest
extends TestbedTest
implements TreeCallback,
TreeRayCastCallback {
    int e_actorCount = 128;
    float worldExtent;
    float m_proxyExtent;
    DynamicTree m_tree;
    AABB m_queryAABB;
    RayCastInput m_rayCastInput;
    RayCastOutput m_rayCastOutput;
    Actor m_rayActor;
    Actor[] m_actors = new Actor[this.e_actorCount];
    int m_stepCount;
    boolean m_automated;
    Random rand = new Random();
    private Vec2Array vecPool = new Vec2Array();

    @Override
    public void initTest(boolean argDeserialized) {
        this.worldExtent = 15.0f;
        this.m_proxyExtent = 0.5f;
        this.m_tree = new DynamicTree();
        for (int i = 0; i < this.e_actorCount; ++i) {
            Actor actor = this.m_actors[i] = new Actor();
            this.GetRandomAABB(actor.aabb);
            actor.proxyId = this.m_tree.createProxy(actor.aabb, actor);
        }
        this.m_stepCount = 0;
        float h = this.worldExtent;
        this.m_queryAABB = new AABB();
        this.m_queryAABB.lowerBound.set(-3.0f, -4.0f + h);
        this.m_queryAABB.upperBound.set(5.0f, 6.0f + h);
        this.m_rayCastInput = new RayCastInput();
        this.m_rayCastInput.p1.set(-5.0f, 5.0f + h);
        this.m_rayCastInput.p2.set(7.0f, -4.0f + h);
        this.m_rayCastInput.maxFraction = 1.0f;
        this.m_rayCastOutput = new RayCastOutput();
        this.m_automated = false;
    }

    @Override
    public void keyPressed(char argKeyChar, int argKeyCode) {
        switch (argKeyChar) {
            case 'a': {
                this.m_automated = !this.m_automated;
                break;
            }
            case 'c': {
                this.CreateProxy();
                break;
            }
            case 'd': {
                this.DestroyProxy();
                break;
            }
            case 'm': {
                this.MoveProxy();
            }
        }
    }

    @Override
    public void step(TestbedSettings settings) {
        int i;
        this.m_rayActor = null;
        for (int i2 = 0; i2 < this.e_actorCount; ++i2) {
            this.m_actors[i2].fraction = 1.0f;
            this.m_actors[i2].overlap = false;
        }
        if (this.m_automated) {
            int actionCount = MathUtils.max(1, this.e_actorCount >> 2);
            for (i = 0; i < actionCount; ++i) {
                this.Action();
            }
        }
        this.Query();
        this.RayCast();
        Vec2[] vecs = this.vecPool.get(4);
        for (i = 0; i < this.e_actorCount; ++i) {
            Actor actor = this.m_actors[i];
            if (actor.proxyId == null) continue;
            Color3f c = new Color3f(0.9f, 0.9f, 0.9f);
            if (actor == this.m_rayActor && actor.overlap) {
                c.set(0.9f, 0.6f, 0.6f);
            } else if (actor == this.m_rayActor) {
                c.set(0.6f, 0.9f, 0.6f);
            } else if (actor.overlap) {
                c.set(0.6f, 0.6f, 0.9f);
            }
            actor.aabb.getVertices(vecs);
            this.getDebugDraw().drawPolygon(vecs, 4, c);
        }
        Color3f c = new Color3f(0.7f, 0.7f, 0.7f);
        this.m_queryAABB.getVertices(vecs);
        this.getDebugDraw().drawPolygon(vecs, 4, c);
        this.getDebugDraw().drawSegment(this.m_rayCastInput.p1, this.m_rayCastInput.p2, c);
        Color3f c1 = new Color3f(0.2f, 0.9f, 0.2f);
        Color3f c2 = new Color3f(0.9f, 0.2f, 0.2f);
        this.getDebugDraw().drawPoint(this.m_rayCastInput.p1, 6.0f, c1);
        this.getDebugDraw().drawPoint(this.m_rayCastInput.p2, 6.0f, c2);
        if (this.m_rayActor != null) {
            Color3f cr = new Color3f(0.2f, 0.2f, 0.9f);
            Vec2 p = this.m_rayCastInput.p2.sub(this.m_rayCastInput.p1).mulLocal(this.m_rayActor.fraction).addLocal(this.m_rayCastInput.p1);
            this.getDebugDraw().drawPoint(p, 6.0f, cr);
        }
        ++this.m_stepCount;
        if (settings.getSetting((String)"Draw Dynamic Tree").enabled) {
            this.m_tree.drawTree(this.getDebugDraw());
        }
        this.m_textLine += 15;
        this.getDebugDraw().drawString(5.0f, this.m_textLine, "(c)reate proxy, (d)estroy proxy, (a)utomate", Color3f.WHITE);
    }

    @Override
    public boolean treeCallback(DynamicTreeNode proxyId) {
        Actor actor = (Actor)proxyId.userData;
        actor.overlap = AABB.testOverlap(this.m_queryAABB, actor.aabb);
        return true;
    }

    @Override
    public float raycastCallback(RayCastInput input, DynamicTreeNode proxyId) {
        Actor actor = (Actor)proxyId.userData;
        RayCastOutput output = new RayCastOutput();
        boolean hit = actor.aabb.raycast(output, input, this.getWorld().getPool());
        if (hit) {
            this.m_rayCastOutput = output;
            this.m_rayActor = actor;
            this.m_rayActor.fraction = output.fraction;
            return output.fraction;
        }
        return input.maxFraction;
    }

    public void GetRandomAABB(AABB aabb) {
        Vec2 w = new Vec2();
        w.set(2.0f * this.m_proxyExtent, 2.0f * this.m_proxyExtent);
        aabb.lowerBound.x = MathUtils.randomFloat(this.rand, -this.worldExtent, this.worldExtent);
        aabb.lowerBound.y = MathUtils.randomFloat(this.rand, 0.0f, 2.0f * this.worldExtent);
        aabb.upperBound.set(aabb.lowerBound).addLocal(w);
    }

    public void MoveAABB(AABB aabb) {
        Vec2 d = new Vec2();
        d.x = MathUtils.randomFloat(this.rand, -0.5f, 0.5f);
        d.y = MathUtils.randomFloat(this.rand, -0.5f, 0.5f);
        aabb.lowerBound.addLocal(d);
        aabb.upperBound.addLocal(d);
        Vec2 c0 = aabb.lowerBound.add(aabb.upperBound).mulLocal(0.5f);
        Vec2 min = new Vec2();
        min.set(-this.worldExtent, 0.0f);
        Vec2 max = new Vec2();
        max.set(this.worldExtent, 2.0f * this.worldExtent);
        Vec2 c = MathUtils.clamp(c0, min, max);
        aabb.lowerBound.addLocal(c.sub(c0));
        aabb.upperBound.addLocal(c.sub(c0));
    }

    public void CreateProxy() {
        for (int i = 0; i < this.e_actorCount; ++i) {
            int j = MathUtils.abs(this.rand.nextInt() % this.e_actorCount);
            Actor actor = this.m_actors[j];
            if (actor.proxyId != null) continue;
            this.GetRandomAABB(actor.aabb);
            actor.proxyId = this.m_tree.createProxy(actor.aabb, actor);
            return;
        }
    }

    public void DestroyProxy() {
        for (int i = 0; i < this.e_actorCount; ++i) {
            int j = MathUtils.abs(this.rand.nextInt() % this.e_actorCount);
            Actor actor = this.m_actors[j];
            if (actor.proxyId == null) continue;
            this.m_tree.destroyProxy(actor.proxyId);
            actor.proxyId = null;
            return;
        }
    }

    public void MoveProxy() {
        for (int i = 0; i < this.e_actorCount; ++i) {
            int j = MathUtils.abs(this.rand.nextInt() % this.e_actorCount);
            Actor actor = this.m_actors[j];
            if (actor.proxyId == null) continue;
            AABB aabb0 = new AABB(actor.aabb);
            this.MoveAABB(actor.aabb);
            Vec2 displacement = actor.aabb.getCenter().sub(aabb0.getCenter());
            this.m_tree.moveProxy(actor.proxyId, new AABB(actor.aabb), displacement);
            return;
        }
    }

    public void Action() {
        int choice = MathUtils.abs(this.rand.nextInt() % 20);
        switch (choice) {
            case 0: {
                this.CreateProxy();
                break;
            }
            case 1: {
                this.DestroyProxy();
                break;
            }
            default: {
                this.MoveProxy();
            }
        }
    }

    public void Query() {
        this.m_tree.query(this, this.m_queryAABB);
        for (int i = 0; i < this.e_actorCount; ++i) {
            if (this.m_actors[i].proxyId == null) continue;
            boolean overlap = AABB.testOverlap(this.m_queryAABB, this.m_actors[i].aabb);
            assert (overlap == this.m_actors[i].overlap);
        }
    }

    public void RayCast() {
        this.m_rayActor = null;
        RayCastInput input = new RayCastInput();
        input.set(this.m_rayCastInput);
        this.m_tree.raycast(this, input);
        Actor bruteActor = null;
        RayCastOutput bruteOutput = new RayCastOutput();
        for (int i = 0; i < this.e_actorCount; ++i) {
            RayCastOutput output;
            boolean hit;
            if (this.m_actors[i].proxyId == null || !(hit = this.m_actors[i].aabb.raycast(output = new RayCastOutput(), input, this.getWorld().getPool()))) continue;
            bruteActor = this.m_actors[i];
            bruteOutput = output;
            input.maxFraction = output.fraction;
        }
        if (bruteActor != null) assert (MathUtils.abs(bruteOutput.fraction - this.m_rayCastOutput.fraction) <= 1.1920929E-7f);
    }

    @Override
    public String getTestName() {
        return "Dynamic Tree";
    }

    public static class Actor {
        AABB aabb = new AABB();
        float fraction;
        boolean overlap;
        DynamicTreeNode proxyId;
    }
}

