/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.joints.GearJoint;
import org.jbox2d.dynamics.joints.GearJointDef;
import org.jbox2d.dynamics.joints.PrismaticJoint;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class Gears
extends TestbedTest {
    RevoluteJoint m_joint1;
    RevoluteJoint m_joint2;
    PrismaticJoint m_joint3;
    GearJoint m_joint4;
    GearJoint m_joint5;

    @Override
    public void initTest(boolean argDeserialized) {
        Body ground = null;
        BodyDef bd = new BodyDef();
        ground = this.getWorld().createBody(bd);
        PolygonShape shape = new PolygonShape();
        shape.setAsEdge(new Vec2(50.0f, 0.0f), new Vec2(-50.0f, 0.0f));
        ground.createFixture(shape, 0.0f);
        CircleShape circle1 = new CircleShape();
        circle1.m_radius = 1.0f;
        CircleShape circle2 = new CircleShape();
        circle2.m_radius = 2.0f;
        PolygonShape box = new PolygonShape();
        box.setAsBox(0.5f, 5.0f);
        BodyDef bd1 = new BodyDef();
        bd1.type = BodyType.DYNAMIC;
        bd1.position.set(-3.0f, 12.0f);
        Body body1 = this.getWorld().createBody(bd1);
        body1.createFixture(circle1, 5.0f);
        RevoluteJointDef jd1 = new RevoluteJointDef();
        jd1.bodyA = ground;
        jd1.bodyB = body1;
        jd1.localAnchorA = ground.getLocalPoint(bd1.position);
        jd1.localAnchorB = body1.getLocalPoint(bd1.position);
        jd1.referenceAngle = body1.getAngle() - ground.getAngle();
        this.m_joint1 = (RevoluteJoint)this.getWorld().createJoint(jd1);
        BodyDef bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        bd2.position.set(0.0f, 12.0f);
        Body body2 = this.getWorld().createBody(bd2);
        body2.createFixture(circle2, 5.0f);
        RevoluteJointDef jd2 = new RevoluteJointDef();
        jd2.initialize(ground, body2, bd2.position);
        this.m_joint2 = (RevoluteJoint)this.getWorld().createJoint(jd2);
        BodyDef bd3 = new BodyDef();
        bd3.type = BodyType.DYNAMIC;
        bd3.position.set(2.5f, 12.0f);
        Body body3 = this.getWorld().createBody(bd3);
        body3.createFixture(box, 5.0f);
        PrismaticJointDef jd3 = new PrismaticJointDef();
        jd3.initialize(ground, body3, bd3.position, new Vec2(0.0f, 1.0f));
        jd3.lowerTranslation = -5.0f;
        jd3.upperTranslation = 5.0f;
        jd3.enableLimit = true;
        this.m_joint3 = (PrismaticJoint)this.getWorld().createJoint(jd3);
        GearJointDef jd4 = new GearJointDef();
        jd4.bodyA = body1;
        jd4.bodyB = body2;
        jd4.joint1 = this.m_joint1;
        jd4.joint2 = this.m_joint2;
        jd4.ratio = circle2.m_radius / circle1.m_radius;
        this.m_joint4 = (GearJoint)this.getWorld().createJoint(jd4);
        GearJointDef jd5 = new GearJointDef();
        jd5.bodyA = body2;
        jd5.bodyB = body3;
        jd5.joint1 = this.m_joint2;
        jd5.joint2 = this.m_joint3;
        jd5.ratio = -1.0f / circle2.m_radius;
        this.m_joint5 = (GearJoint)this.getWorld().createJoint(jd5);
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        float ratio = this.m_joint4.getRatio();
        float value = this.m_joint1.getJointAngle() + ratio * this.m_joint2.getJointAngle();
        this.addTextLine("theta1 + " + ratio + " * theta2 = " + value);
        ratio = this.m_joint5.getRatio();
        value = this.m_joint2.getJointAngle() + ratio * this.m_joint3.getJointTranslation();
        this.addTextLine("theta2 + " + ratio + " * delta = " + value);
    }

    @Override
    public String getTestName() {
        return "Gears";
    }
}

