/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;
import org.jbox2d.testbed.tests.RayCastAnyCallback;
import org.jbox2d.testbed.tests.RayCastClosestCallback;
import org.jbox2d.testbed.tests.RayCastMultipleCallback;

public class RayCastTest
extends TestbedTest {
    public static final int e_maxBodies = 256;
    int m_bodyIndex;
    Body[] m_bodies;
    Integer[] m_userData;
    PolygonShape[] m_polygons;
    CircleShape m_circle;
    float m_angle;
    Mode m_mode;
    RayCastClosestCallback ccallback = new RayCastClosestCallback();
    RayCastAnyCallback acallback = new RayCastAnyCallback();
    RayCastMultipleCallback mcallback = new RayCastMultipleCallback();
    Vec2 point1 = new Vec2();
    Vec2 d = new Vec2();
    Vec2 pooledHead = new Vec2();
    Vec2 point2 = new Vec2();

    @Override
    public String getTestName() {
        return "Raycast";
    }

    @Override
    public void initTest(boolean argDeserialized) {
        this.m_bodies = new Body[256];
        this.m_userData = new Integer[256];
        this.m_polygons = new PolygonShape[4];
        BodyDef bd = new BodyDef();
        Body ground = this.getWorld().createBody(bd);
        PolygonShape shape = new PolygonShape();
        shape.setAsEdge(new Vec2(-40.0f, 0.0f), new Vec2(40.0f, 0.0f));
        ground.createFixture(shape, 0.0f);
        Vec2[] vertices = new Vec2[]{new Vec2(-0.5f, 0.0f), new Vec2(0.5f, 0.0f), new Vec2(0.0f, 1.5f)};
        this.m_polygons[0] = new PolygonShape();
        this.m_polygons[0].set(vertices, 3);
        vertices = new Vec2[]{new Vec2(-0.1f, 0.0f), new Vec2(0.1f, 0.0f), new Vec2(0.0f, 1.5f)};
        this.m_polygons[1] = new PolygonShape();
        this.m_polygons[1].set(vertices, 3);
        float w = 1.0f;
        float b = w / (2.0f + MathUtils.sqrt(2.0f));
        float s = MathUtils.sqrt(2.0f) * b;
        Vec2[] vertices2 = new Vec2[]{new Vec2(0.5f * s, 0.0f), new Vec2(0.5f * w, b), new Vec2(0.5f * w, b + s), new Vec2(0.5f * s, w), new Vec2(-0.5f * s, w), new Vec2(-0.5f * w, b + s), new Vec2(-0.5f * w, b), new Vec2(-0.5f * s, 0.0f)};
        this.m_polygons[2] = new PolygonShape();
        this.m_polygons[2].set(vertices2, 8);
        this.m_polygons[3] = new PolygonShape();
        this.m_polygons[3].setAsBox(0.5f, 0.5f);
        this.m_circle = new CircleShape();
        this.m_circle.m_radius = 0.5f;
        this.m_bodyIndex = 0;
        this.m_angle = 0.0f;
        this.m_mode = Mode.e_closest;
    }

    @Override
    public void step(TestbedSettings settings) {
        boolean advanceRay = !settings.pause || settings.singleStep;
        super.step(settings);
        this.addTextLine("Press 1-5 to drop stuff, m to change the mode");
        this.addTextLine("Polygon 1 is filtered");
        this.addTextLine("Mode = " + (Object)((Object)this.m_mode));
        float L = 11.0f;
        this.point1.set(0.0f, 10.0f);
        this.d.set(L * MathUtils.cos(this.m_angle), L * MathUtils.sin(this.m_angle));
        this.point2.set(this.point1);
        this.point2.addLocal(this.d);
        if (this.m_mode == Mode.e_closest) {
            this.ccallback.init();
            this.getWorld().raycast(this.ccallback, this.point1, this.point2);
            if (this.ccallback.m_hit) {
                this.getDebugDraw().drawPoint(this.ccallback.m_point, 5.0f, new Color3f(0.4f, 0.9f, 0.4f));
                this.getDebugDraw().drawSegment(this.point1, this.ccallback.m_point, new Color3f(0.8f, 0.8f, 0.8f));
                this.pooledHead.set(this.ccallback.m_normal);
                this.pooledHead.mulLocal(0.5f).addLocal(this.ccallback.m_point);
                this.getDebugDraw().drawSegment(this.ccallback.m_point, this.pooledHead, new Color3f(0.9f, 0.9f, 0.4f));
            } else {
                this.getDebugDraw().drawSegment(this.point1, this.point2, new Color3f(0.8f, 0.8f, 0.8f));
            }
        } else if (this.m_mode == Mode.e_any) {
            this.acallback.init();
            this.getWorld().raycast(this.acallback, this.point1, this.point2);
            if (this.acallback.m_hit) {
                this.getDebugDraw().drawPoint(this.acallback.m_point, 5.0f, new Color3f(0.4f, 0.9f, 0.4f));
                this.getDebugDraw().drawSegment(this.point1, this.acallback.m_point, new Color3f(0.8f, 0.8f, 0.8f));
                this.pooledHead.set(this.acallback.m_normal);
                this.pooledHead.mulLocal(0.5f).addLocal(this.acallback.m_point);
                this.getDebugDraw().drawSegment(this.acallback.m_point, this.pooledHead, new Color3f(0.9f, 0.9f, 0.4f));
            } else {
                this.getDebugDraw().drawSegment(this.point1, this.point2, new Color3f(0.8f, 0.8f, 0.8f));
            }
        } else if (this.m_mode == Mode.e_multiple) {
            this.mcallback.init();
            this.getWorld().raycast(this.mcallback, this.point1, this.point2);
            this.getDebugDraw().drawSegment(this.point1, this.point2, new Color3f(0.8f, 0.8f, 0.8f));
            for (int i = 0; i < this.mcallback.m_count; ++i) {
                Vec2 p = this.mcallback.m_points[i];
                Vec2 n = this.mcallback.m_normals[i];
                this.getDebugDraw().drawPoint(p, 5.0f, new Color3f(0.4f, 0.9f, 0.4f));
                this.getDebugDraw().drawSegment(this.point1, p, new Color3f(0.8f, 0.8f, 0.8f));
                this.pooledHead.set(n);
                this.pooledHead.mulLocal(0.5f).addLocal(p);
                this.getDebugDraw().drawSegment(p, this.pooledHead, new Color3f(0.9f, 0.9f, 0.4f));
            }
        }
        if (advanceRay) {
            this.m_angle += 0.004363323f;
        }
    }

    void Create(int index) {
        if (this.m_bodies[this.m_bodyIndex] != null) {
            this.getWorld().destroyBody(this.m_bodies[this.m_bodyIndex]);
            this.m_bodies[this.m_bodyIndex] = null;
        }
        BodyDef bd = new BodyDef();
        float x = (float)Math.random() * 20.0f - 10.0f;
        float y = (float)Math.random() * 20.0f;
        bd.position.set(x, y);
        bd.angle = (float)Math.random() * ((float)Math.PI * 2) - (float)Math.PI;
        this.m_userData[this.m_bodyIndex] = index;
        bd.userData = this.m_userData[this.m_bodyIndex];
        if (index == 4) {
            bd.angularDamping = 0.02f;
        }
        this.m_bodies[this.m_bodyIndex] = this.getWorld().createBody(bd);
        if (index < 4) {
            FixtureDef fd = new FixtureDef();
            fd.shape = this.m_polygons[index];
            fd.friction = 0.3f;
            this.m_bodies[this.m_bodyIndex].createFixture(fd);
        } else {
            FixtureDef fd = new FixtureDef();
            fd.shape = this.m_circle;
            fd.friction = 0.3f;
            this.m_bodies[this.m_bodyIndex].createFixture(fd);
        }
        this.m_bodyIndex = (this.m_bodyIndex + 1) % 256;
    }

    void DestroyBody() {
        for (int i = 0; i < 256; ++i) {
            if (this.m_bodies[i] == null) continue;
            this.getWorld().destroyBody(this.m_bodies[i]);
            this.m_bodies[i] = null;
            return;
        }
    }

    @Override
    public void keyPressed(char argKeyChar, int argKeyCode) {
        switch (argKeyChar) {
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                this.Create(argKeyChar - 49);
                break;
            }
            case 'd': {
                this.DestroyBody();
                break;
            }
            case 'm': {
                if (this.m_mode == Mode.e_closest) {
                    this.m_mode = Mode.e_any;
                    break;
                }
                if (this.m_mode == Mode.e_any) {
                    this.m_mode = Mode.e_multiple;
                    break;
                }
                if (this.m_mode != Mode.e_multiple) break;
                this.m_mode = Mode.e_closest;
            }
        }
    }

    static enum Mode {
        e_closest,
        e_any,
        e_multiple;

    }
}

