/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class RevoluteTest
extends TestbedTest {
    private RevoluteJoint m_joint;
    private boolean isLeft = false;

    @Override
    public void initTest(boolean argDeserialized) {
        Body ground = null;
        BodyDef bd = new BodyDef();
        ground = this.getWorld().createBody(bd);
        PolygonShape shape = new PolygonShape();
        shape.setAsEdge(new Vec2(-40.0f, 0.0f), new Vec2(40.0f, 0.0f));
        ground.createFixture(shape, 0.0f);
        CircleShape shape2 = new CircleShape();
        shape2.m_radius = 0.5f;
        BodyDef bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        RevoluteJointDef rjd = new RevoluteJointDef();
        bd2.position.set(0.0f, 20.0f);
        Body body = this.getWorld().createBody(bd2);
        body.createFixture(shape2, 5.0f);
        float w = 100.0f;
        body.setAngularVelocity(w);
        body.setLinearVelocity(new Vec2(-8.0f * w, 0.0f));
        rjd.initialize(ground, body, new Vec2(0.0f, 12.0f));
        rjd.motorSpeed = (float)(-Math.PI);
        rjd.maxMotorTorque = 10000.0f;
        rjd.enableMotor = false;
        rjd.lowerAngle = -0.7853982f;
        rjd.upperAngle = 1.5707964f;
        rjd.enableLimit = true;
        rjd.collideConnected = true;
        this.m_joint = (RevoluteJoint)this.getWorld().createJoint(rjd);
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("Limits " + (this.m_joint.isLimitEnabled() ? "on" : "off") + ", Motor " + (this.m_joint.isMotorEnabled() ? "on " : "off ") + (this.isLeft ? "left" : "right"));
        this.addTextLine("Keys: (l) limits, (m) motor, (a) left, (d) right");
    }

    @Override
    public void keyPressed(char argKeyChar, int argKeyCode) {
        switch (argKeyChar) {
            case 'l': {
                this.m_joint.enableLimit(!this.m_joint.isLimitEnabled());
                this.getModel().getKeys()[108] = false;
                break;
            }
            case 'm': {
                this.m_joint.enableMotor(!this.m_joint.isMotorEnabled());
                this.getModel().getKeys()[109] = false;
                break;
            }
            case 'a': {
                this.m_joint.setMotorSpeed((float)Math.PI);
                this.getModel().getKeys()[97] = false;
                this.isLeft = true;
                break;
            }
            case 'd': {
                this.m_joint.setMotorSpeed((float)(-Math.PI));
                this.getModel().getKeys()[100] = false;
                this.isLeft = false;
            }
        }
    }

    @Override
    public String getTestName() {
        return "Revolute";
    }
}

