/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import java.util.Formatter;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.joints.PrismaticJoint;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class SliderCrankTest
extends TestbedTest {
    private RevoluteJoint m_joint1;
    private PrismaticJoint m_joint2;

    @Override
    public void initTest(boolean argDeserialized) {
        Body ground = null;
        BodyDef bd = new BodyDef();
        ground = this.getWorld().createBody(bd);
        PolygonShape shape = new PolygonShape();
        shape.setAsEdge(new Vec2(-40.0f, 0.0f), new Vec2(40.0f, 0.0f));
        ground.createFixture(shape, 0.0f);
        Body prevBody = ground;
        shape = new PolygonShape();
        shape.setAsBox(0.5f, 2.0f);
        BodyDef bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        bd2.position.set(0.0f, 7.0f);
        Body body = this.getWorld().createBody(bd2);
        body.createFixture(shape, 2.0f);
        RevoluteJointDef rjd = new RevoluteJointDef();
        rjd.initialize(prevBody, body, new Vec2(0.0f, 5.0f));
        rjd.motorSpeed = (float)Math.PI;
        rjd.maxMotorTorque = 10000.0f;
        rjd.enableMotor = true;
        this.m_joint1 = (RevoluteJoint)this.getWorld().createJoint(rjd);
        prevBody = body;
        shape = new PolygonShape();
        shape.setAsBox(0.5f, 4.0f);
        bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        bd2.position.set(0.0f, 13.0f);
        body = this.getWorld().createBody(bd2);
        body.createFixture(shape, 2.0f);
        rjd = new RevoluteJointDef();
        rjd.initialize(prevBody, body, new Vec2(0.0f, 9.0f));
        rjd.enableMotor = false;
        this.getWorld().createJoint(rjd);
        prevBody = body;
        shape = new PolygonShape();
        shape.setAsBox(1.5f, 1.5f);
        bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        bd2.position.set(0.0f, 17.0f);
        body = this.getWorld().createBody(bd2);
        body.createFixture(shape, 2.0f);
        rjd = new RevoluteJointDef();
        rjd.initialize(prevBody, body, new Vec2(0.0f, 17.0f));
        this.getWorld().createJoint(rjd);
        PrismaticJointDef pjd = new PrismaticJointDef();
        pjd.initialize(ground, body, new Vec2(0.0f, 17.0f), new Vec2(0.0f, 1.0f));
        pjd.maxMotorForce = 1000.0f;
        pjd.enableMotor = true;
        this.m_joint2 = (PrismaticJoint)this.getWorld().createJoint(pjd);
        shape = new PolygonShape();
        shape.setAsBox(1.5f, 1.5f);
        bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        bd2.position.set(0.0f, 23.0f);
        body = this.getWorld().createBody(bd2);
        body.createFixture(shape, 2.0f);
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("Keys: (f) toggle friction, (m) toggle motor");
        float torque = this.m_joint1.getMotorTorque();
        Formatter f = new Formatter();
        this.addTextLine(f.format("Friction: %b, Motor Force = %5.0f, ", this.m_joint2.isMotorEnabled(), Float.valueOf(torque)).toString());
    }

    @Override
    public void keyPressed(char argKeyChar, int argKeyCode) {
        switch (argKeyChar) {
            case 'f': {
                this.m_joint2.enableMotor(!this.m_joint2.isMotorEnabled());
                this.getModel().getKeys()[102] = false;
                break;
            }
            case 'm': {
                this.m_joint1.enableMotor(!this.m_joint1.isMotorEnabled());
                this.getModel().getKeys()[109] = false;
            }
        }
    }

    @Override
    public String getTestName() {
        return "Slider Crank";
    }
}

