/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.peditor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.newdawn.slick.tools.peditor.DefaultPanel;
import org.newdawn.slick.tools.peditor.InputPanelListener;

public class MinMaxPanel
extends DefaultPanel {
    private JSpinner minSpinner;
    private JSpinner maxSpinner;
    private ArrayList listeners = new ArrayList();
    private boolean updateDisable = false;
    private JCheckBox enabled = new JCheckBox("Enabled");
    private int offValue;
    private boolean enablement;

    public MinMaxPanel(String name, int min, int max, int defMin, int defMax, String toolTip) {
        this(name, min, max, defMin, defMax, false, 0, toolTip);
    }

    public MinMaxPanel(String name, int min, int max, int defMin, int defMax, boolean enablement, int offValue, String toolTip) {
        this.setLayout(null);
        this.setToolTipText(toolTip);
        this.offValue = offValue;
        this.enablement = enablement;
        int offset = 0;
        if (enablement) {
            this.enabled.setBounds(10, 20, 200, 20);
            this.add(this.enabled);
            offset += 20;
            this.enabled.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MinMaxPanel.this.minSpinner.setEnabled(MinMaxPanel.this.enabled.isSelected());
                    MinMaxPanel.this.maxSpinner.setEnabled(MinMaxPanel.this.enabled.isSelected());
                    MinMaxPanel.this.fireUpdated(null);
                }
            });
        }
        this.minSpinner = new JSpinner(new SpinnerNumberModel(defMin, min, max, 1));
        this.maxSpinner = new JSpinner(new SpinnerNumberModel(defMax, min, max, 1));
        this.minSpinner.setBounds(50, 20 + offset, 80, 20);
        this.maxSpinner.setBounds(190, 20 + offset, 80, 20);
        this.minSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MinMaxPanel.this.fireUpdated(e.getSource());
            }
        });
        this.maxSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MinMaxPanel.this.fireUpdated(e.getSource());
            }
        });
        JLabel minLabel = new JLabel("Min");
        minLabel.setBounds(10, 20 + offset, 40, 20);
        this.add(minLabel);
        JLabel maxLabel = new JLabel("Max");
        maxLabel.setBounds(150, 20 + offset, 40, 20);
        this.add(maxLabel);
        this.add(this.minSpinner);
        this.add(this.maxSpinner);
        this.setBorder(BorderFactory.createTitledBorder(name));
        if (enablement) {
            this.minSpinner.setEnabled(false);
            this.maxSpinner.setEnabled(false);
        }
    }

    public void setEnabled(boolean e) {
        this.enabled.setEnabled(e);
        this.minSpinner.setEnabled(this.enabled.isSelected() || !this.enablement);
        this.maxSpinner.setEnabled(this.enabled.isSelected() || !this.enablement);
    }

    public void setEnabledForced(boolean e) {
        this.enabled.setEnabled(e);
        this.minSpinner.setEnabled(e);
        this.maxSpinner.setEnabled(e);
    }

    public void setMin(int value) {
        this.updateDisable = true;
        this.minSpinner.setValue(new Integer(value));
        this.updateDisable = false;
    }

    public void setMax(int value) {
        this.updateDisable = true;
        this.maxSpinner.setValue(new Integer(value));
        this.updateDisable = false;
    }

    public void addListener(InputPanelListener listener) {
        this.listeners.add(listener);
    }

    public int getOffset() {
        return this.enablement ? 65 : 45;
    }

    void fireUpdated(Object source) {
        if (this.updateDisable) {
            return;
        }
        if (source == this.maxSpinner && this.getMax() < this.getMin()) {
            this.setMin(this.getMax());
        }
        if (source == this.minSpinner && this.getMax() < this.getMin()) {
            this.setMax(this.getMin());
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((InputPanelListener)this.listeners.get(i)).minMaxUpdated(this);
        }
    }

    public boolean getEnabled() {
        return !this.enablement || this.enabled.isSelected();
    }

    public void setEnabledValue(boolean e) {
        if (this.enablement) {
            this.enabled.setSelected(e);
        }
        this.minSpinner.setEnabled(this.enabled.isSelected() || !this.enablement);
        this.maxSpinner.setEnabled(this.enabled.isSelected() || !this.enablement);
    }

    public int getMax() {
        if (this.enablement && !this.enabled.isSelected()) {
            return this.offValue;
        }
        return (Integer)this.maxSpinner.getValue();
    }

    public int getMin() {
        if (this.enablement && !this.enabled.isSelected()) {
            return this.offValue;
        }
        return (Integer)this.minSpinner.getValue();
    }
}

