/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.peditor;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.BasicGame;
import org.newdawn.slick.Color;
import org.newdawn.slick.Font;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.InputListener;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.particles.ConfigurableEmitter;
import org.newdawn.slick.particles.ParticleEmitter;
import org.newdawn.slick.particles.ParticleSystem;
import org.newdawn.slick.tools.peditor.ParticleEditor;
import org.newdawn.slick.util.Log;

public class ParticleGame
extends BasicGame {
    private ArrayList waiting = new ArrayList();
    private ParticleSystem system;
    private Font defaultFont;
    private ArrayList emitters = new ArrayList();
    private int max;
    private boolean hudOn = true;
    private boolean paused;
    private int systemMove;
    private float ypos;
    private File backgroundImage;
    private Image background;
    private InputListener listener;

    public ParticleGame(ParticleEditor editor) throws LWJGLException {
        super("Particle Game");
    }

    public void setListener(InputListener listener) {
        this.listener = listener;
    }

    public void setBackgroundImage(File file) {
        this.backgroundImage = file;
        this.background = null;
    }

    public void setSystemMove(int move, boolean reset) {
        this.systemMove = move;
        if (reset) {
            this.ypos = 0.0f;
        }
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isHudOn() {
        return this.hudOn;
    }

    public void setHud(boolean hud) {
        this.hudOn = hud;
    }

    public void addEmitter(ConfigurableEmitter emitter) {
        this.emitters.add(emitter);
        if (this.system == null) {
            this.waiting.add(emitter);
        } else {
            this.system.addEmitter(emitter);
        }
    }

    public void removeEmitter(ConfigurableEmitter emitter) {
        this.emitters.remove(emitter);
        this.system.removeEmitter(emitter);
    }

    public void clearSystem(boolean additive) {
        this.system = new ParticleSystem("org/newdawn/slick/data/particle.tga", 2000);
        if (additive) {
            this.system.setBlendingMode(1);
        }
        this.system.setRemoveCompletedEmitters(false);
    }

    public void setSystem(ParticleSystem system) {
        this.system = system;
        this.emitters.clear();
        system.setRemoveCompletedEmitters(false);
        for (int i = 0; i < system.getEmitterCount(); ++i) {
            this.emitters.add(system.getEmitter(i));
        }
    }

    public void resetCounts() {
        this.max = 0;
    }

    public ParticleSystem getSystem() {
        return this.system;
    }

    public void init(GameContainer container) throws SlickException {
        container.getInput().addListener(this.listener);
        container.setShowFPS(false);
        this.system = new ParticleSystem("org/newdawn/slick/data/particle.tga", 2000);
        this.system.setBlendingMode(1);
        this.system.setRemoveCompletedEmitters(false);
        for (int i = 0; i < this.waiting.size(); ++i) {
            this.system.addEmitter((ParticleEmitter)this.waiting.get(i));
        }
        this.waiting.clear();
    }

    public void update(GameContainer container, int delta) throws SlickException {
        if (!this.paused) {
            int i;
            this.ypos = (float)((double)this.ypos + (double)delta * 0.002 * (double)this.systemMove);
            if (this.ypos > 300.0f) {
                this.ypos = -300.0f;
            }
            if (this.ypos < -300.0f) {
                this.ypos = 300.0f;
            }
            for (i = 0; i < this.emitters.size(); ++i) {
                ((ConfigurableEmitter)this.emitters.get(i)).replayCheck();
            }
            for (i = 0; i < delta; ++i) {
                this.system.update(1);
            }
        }
        Display.sync(100);
    }

    public void render(GameContainer container, Graphics g) throws SlickException {
        try {
            if (this.backgroundImage != null && this.background == null) {
                this.background = new Image(new FileInputStream(this.backgroundImage), this.backgroundImage.getAbsolutePath(), false);
            }
        }
        catch (Exception e) {
            Log.error("Failed to load backgroundImage: " + this.backgroundImage);
            Log.error(e);
            this.backgroundImage = null;
            this.background = null;
        }
        GL11.glClear(16384);
        GL11.glLoadIdentity();
        if (this.background != null) {
            g.fillRect(0.0f, 0.0f, container.getWidth(), container.getHeight(), this.background, 0.0f, 0.0f);
        }
        this.max = Math.max(this.max, this.system.getParticleCount());
        if (this.hudOn) {
            g.setColor(Color.white);
            g.drawString("FPS: " + container.getFPS(), 10.0f, 10.0f);
            g.drawString("Particles: " + this.system.getParticleCount(), 10.0f, 25.0f);
            g.drawString("Max: " + this.max, 10.0f, 40.0f);
            g.drawString("LMB: Position Emitter       RMB: Default Position", 20.0f, 527.0f);
        }
        GL11.glTranslatef(250.0f, 300.0f, 0.0f);
        for (int i = 0; i < this.emitters.size(); ++i) {
            ((ConfigurableEmitter)this.emitters.get(i)).setPosition(0.0f, this.ypos);
        }
        this.system.render();
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.5f));
        g.fillRect(-1.0f, -5.0f, 2.0f, 10.0f);
        g.fillRect(-5.0f, -1.0f, 10.0f, 2.0f);
    }
}

