/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.peditor;

import org.newdawn.slick.particles.ConfigurableEmitter;
import org.newdawn.slick.tools.peditor.ControlPanel;
import org.newdawn.slick.tools.peditor.InputPanelListener;
import org.newdawn.slick.tools.peditor.MinMaxPanel;
import org.newdawn.slick.tools.peditor.ValuePanel;

public class PositionControls
extends ControlPanel
implements InputPanelListener {
    private MinMaxPanel xoffset;
    private MinMaxPanel yoffset;

    public PositionControls() {
        this.setLayout(null);
        this.xoffset = new MinMaxPanel("X Offset", -10000, 10000, 1, 1, "The offset on the x-axis at which particles will appear");
        this.addMinMax("x", this.xoffset);
        this.yoffset = new MinMaxPanel("Y Offset", -10000, 10000, 1, 1, "The offset on the y-axis at which particles will appear");
        this.addMinMax("y", this.yoffset);
        this.addValue("spread", new ValuePanel("Spread Angle (degrees)", 0, 360, 360, "The range of angles the particles can spew out in", false));
        this.addValue("angularOffset", new ValuePanel("Angular Offset (degrees)", 0, 360, 360, "The direction the particles should spill out at", false));
        this.addMinMax("initialDistance", new MinMaxPanel("Initial Distance", 0, 10000, 0, 0, "The distance from the emitter center particles will appear at"));
    }

    public void setPosition(int x, int y) {
        int cx = (this.xoffset.getMin() + this.xoffset.getMax()) / 2;
        int cy = (this.yoffset.getMin() + this.yoffset.getMax()) / 2;
        int dx = x - cx;
        int dy = y - cy;
        this.xoffset.setMin(this.xoffset.getMin() + dx);
        this.xoffset.setMax(this.xoffset.getMax() + dx);
        this.yoffset.setMin(this.yoffset.getMin() + dy);
        this.yoffset.setMax(this.yoffset.getMax() + dy);
        this.xoffset.fireUpdated(null);
        this.yoffset.fireUpdated(null);
    }

    protected void linkEmitterToFields(ConfigurableEmitter emitter) {
        this.link(emitter.xOffset, "x");
        this.link(emitter.yOffset, "y");
        this.link(emitter.spread, "spread");
        this.link(emitter.angularOffset, "angularOffset");
        this.link(emitter.initialDistance, "initialDistance");
    }
}

