/*
 * Decompiled with CFR 0.152.
 */
package nanoblood;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import nanoblood.util.GameParams;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.UnicodeFont;
import org.newdawn.slick.font.effects.ColorEffect;
import org.newdawn.slick.font.effects.OutlineEffect;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.util.ResourceLoader;

public class GameOver
extends BasicGameState {
    int stateID = -1;
    Image bg;
    private GameContainer lastgc;
    private StateBasedGame lastsbg;
    private static final int X_OFFSET = 20;
    private static final int Y_OFFSET = 20;
    private int score;
    private UnicodeFont unicodeFont;

    GameOver(int stateID) {
        this.stateID = stateID;
    }

    @Override
    public int getID() {
        return this.stateID;
    }

    @Override
    public void init(GameContainer gc, StateBasedGame sbg) throws SlickException {
        this.bg = new Image("sprites/game_over.jpg");
        Font javaFont = null;
        try {
            javaFont = Font.createFont(0, ResourceLoader.getResourceAsStream("fonts/LCD_Mono_Normal.ttf"));
        }
        catch (FontFormatException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.unicodeFont = new UnicodeFont(javaFont, 72, false, false);
        this.unicodeFont.getEffects().add(new ColorEffect(Color.white));
        this.unicodeFont.getEffects().add(new OutlineEffect(4, new Color(0, 255, 100, 64)));
        this.unicodeFont.addGlyphs("0123456789 pts");
        this.unicodeFont.loadGlyphs();
    }

    @Override
    public void render(GameContainer gc, StateBasedGame sbg, Graphics gr) throws SlickException {
        this.lastgc = gc;
        this.lastsbg = sbg;
        this.bg.draw(0.0f, 0.0f, 1280.0f, 720.0f);
        this.score = GameParams.INSTANCE.getLastScore();
        String scoreText = this.score + " pts";
        int textWidth = this.unicodeFont.getWidth(scoreText);
        gr.setColor(org.newdawn.slick.Color.white);
        gr.setFont(this.unicodeFont);
        gr.drawString(scoreText, 1260 - textWidth, 20.0f);
    }

    @Override
    public void update(GameContainer gc, StateBasedGame sbg, int i) throws SlickException {
        Input input = gc.getInput();
        if (input.isKeyDown(1)) {
            System.exit(0);
        }
    }
}

