/*
 * Decompiled with CFR 0.152.
 */
package nanoblood;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import nanoblood.Cancer;
import nanoblood.GlobuleBlanc;
import nanoblood.GlobuleRouge;
import nanoblood.Laser;
import nanoblood.LevelManager;
import nanoblood.Obstacle;
import nanoblood.PhysicsObject;
import nanoblood.Player;
import nanoblood.Splash;
import nanoblood.Sprite;
import nanoblood.Virus;
import nanoblood.sound.SoundID;
import nanoblood.sound.SoundManager;
import nanoblood.ui.HeartBeatDisplay;
import nanoblood.ui.LifeDisplay;
import nanoblood.ui.ScoreDisplay;
import nanoblood.util.GameParams;
import nanoblood.util.IObservable;
import nanoblood.util.IObserver;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.World;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;

public class GamePlay
extends BasicGameState
implements IObservable {
    private static GamePlay gp = null;
    private float scrollDelta;
    int stateID = -1;
    PhysicsObject player;
    LevelManager levelManager;
    List<PhysicsObject> objects;
    List<PhysicsObject> lasers;
    List<Splash> splashes;
    float bloodSpeed = 0.0f;
    final int bloodSpeedImpulse = 1;
    final double bloodSpeedDecrease = 0.01;
    public static final int IMPULSE_COEFF_SLOW = 6;
    public static final int IMPULSE_COEFF_MEDIUM = 8;
    public static final int IMPULSE_COEFF_HARD = 9;
    public static final int IMPULSE_COEFF_CRAZY = 9;
    private Vec2 gravity;
    private BodyDef playerBodyDef;
    private Body playerBody;
    private PolygonShape playerShape;
    private FixtureDef playerFD;
    private float timeStep;
    private int velocityIterations;
    private int positionIterations;
    World world;
    int totalDistance = 0;
    float scrolledDistance = 0.0f;
    int nextDistancePopObstacle;
    int deltaDistancePopObstacle = 4;
    private Vec2 speedImpulse;
    private int currentHeartBeat = 50;
    public static final int INITIAL_HEARTBEATS = 50;
    private int HEARTBEAT_THRESHOLD_CRAZY = 150;
    private int HEARTBEAT_THRESHOLD_MEDIUM = 90;
    private int HEARTBEAT_THRESHOLD_HARD = 120;
    private int heartBeatsSinceLastUpdate = 0;
    protected static final float PIXELS_TO_METERS_RATIO = 10.0f;
    static final int OBSTACLE_SPAWN_DELAY = 300;
    private static boolean DBG = false;
    private LinkedList<Long> HBList = new LinkedList();
    int score;
    float life;
    ScoreDisplay scoreDisplay;
    LifeDisplay lifeDisplay;
    HeartBeatDisplay heartBeatDisplay;
    private boolean hasChanged;
    private ArrayList<IObserver> observers;
    private GameContainer lastGc;
    private StateBasedGame lastSbg;
    long lastTick;
    long elapsedTime;
    boolean laserTop = true;
    private Sound hbSound;
    private int heartBeatAvgInterval = 5;

    public static GamePlay getGP() {
        return gp;
    }

    GamePlay(int stateID) {
        this.stateID = stateID;
        gp = this;
    }

    @Override
    public int getID() {
        return this.stateID;
    }

    @Override
    public void init(GameContainer gc, StateBasedGame sbg) throws SlickException {
        this.initPhysics();
        this.player = new PhysicsObject(new Player(), this.playerBody);
        try {
            this.levelManager = new LevelManager(this.world);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(GamePlay.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.objects = new ArrayList<PhysicsObject>();
        this.lasers = new ArrayList<PhysicsObject>();
        this.splashes = new ArrayList<Splash>();
        this.objects = new ArrayList<PhysicsObject>();
        this.hasChanged = false;
        this.observers = new ArrayList();
        this.score = 0;
        this.life = GameParams.INSTANCE.MaxLife();
        this.scoreDisplay = new ScoreDisplay();
        this.lifeDisplay = new LifeDisplay();
        this.heartBeatDisplay = new HeartBeatDisplay();
        this.observers.add(this.scoreDisplay);
        this.observers.add(this.lifeDisplay);
        this.observers.add(this.heartBeatDisplay);
        this.setChanged();
        this.notifyObservers();
        this.lastTick = System.currentTimeMillis();
        this.elapsedTime = 0L;
        for (int i = 0; i < 6; ++i) {
            Obstacle o = Obstacle.getRandomObstacle();
            o.setCoords(i * 200, (int)(Math.random() * 720.0));
            PhysicsObject phyObj = PhysicsObject.createFromCircSprite(o, this.world);
            this.objects.add(phyObj);
        }
    }

    @Override
    public void enter(GameContainer container, StateBasedGame game) throws SlickException {
        Date date = new Date();
        int i = 0;
        while ((double)i < 0.8333333333333334 * (double)this.heartBeatAvgInterval + 1.0) {
            this.HBList.add(date.getTime());
            ++i;
        }
    }

    @Override
    public void render(GameContainer gc, StateBasedGame sbg, Graphics grphcs) throws SlickException {
        this.lastGc = gc;
        this.lastSbg = sbg;
        this.levelManager.render(gc, sbg, grphcs);
        for (Splash s : this.splashes) {
            s.getRenderable().draw((float)s.getCoords().getX(), (float)s.getCoords().getY());
        }
        for (PhysicsObject so : this.objects) {
            so.getRenderable().draw((float)so.getCoords().getX(), (float)so.getCoords().getY());
        }
        for (PhysicsObject so : this.lasers) {
            so.getRenderable().draw((float)so.getCoords().getX(), (float)so.getCoords().getY());
        }
        this.player.getRenderable().draw((float)this.player.getCoords().getX(), (float)this.player.getCoords().getY());
        ((Player)this.player.getSprite()).getCanons().draw((float)this.player.getCoords().getX(), (float)this.player.getCoords().getY() - 4.0f);
        if (((Player)this.player.getSprite()).isShieldActivated()) {
            ((Player)this.player.getSprite()).shield.draw((float)this.player.getCoords().getX() - 25.0f, (float)this.player.getCoords().getY() - 25.0f);
        }
        this.scoreDisplay.render(gc, sbg, grphcs);
        this.lifeDisplay.render(gc, sbg, grphcs);
        this.heartBeatDisplay.render(gc, sbg, grphcs);
    }

    @Override
    public void update(GameContainer gc, StateBasedGame sbg, int delta) throws SlickException {
        this.removeObjects();
        this.addObjects();
        this.manageInput(gc, sbg, delta);
        this.updateCurrentHB(delta);
        this.updatePhysics();
        this.updateObjects();
        this.updateLasers();
        this.updateSplashes();
        try {
            this.levelManager.update(GamePlay.m2px(this.scrollDelta), GamePlay.m2px(this.scrolledDistance));
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(GamePlay.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.manageColisions();
        long currentTime = System.currentTimeMillis();
        this.elapsedTime = currentTime - this.lastTick;
        if (this.elapsedTime >= 1000L) {
            this.elapsedTime -= 1000L;
            this.lastTick = currentTime;
            float scoreModifier = this.getScoreModifier();
            this.addScore((int)((float)GameParams.INSTANCE.ScorePerSecond() * scoreModifier));
            if ((float)this.currentHeartBeat < GameParams.INSTANCE.BeatThreshold1()) {
                this.addLife(-GameParams.INSTANCE.DamageLowBeat());
            } else if ((float)this.currentHeartBeat > GameParams.INSTANCE.BeatThreshold4()) {
                this.addLife(-GameParams.INSTANCE.DamageHighBeat());
            }
        }
        if (this.player.getCoords().getY() < 0.0 || this.player.getBody().getPosition().y < 0.0f || this.player.getSprite().coords.getY() < 0.0) {
            this.player.getBody().getPosition().y = 0.0f;
            this.player.getSprite().setCoords((int)this.player.getSprite().getCoords().getX(), 0);
        } else if (this.player.getCoords().getY() > 720.0 || this.player.getBody().getPosition().y > 720.0f || this.player.getSprite().coords.getY() > 720.0) {
            this.player.getBody().getPosition().y = 720.0f;
            this.player.getSprite().setCoords((int)this.player.getSprite().getCoords().getX(), 720);
        }
        if (this.life <= 0.0f) {
            SoundManager.INSTANCE.stopSound(SoundID.THEME);
            SoundManager.INSTANCE.playAsSoundEffect(SoundID.GAMEOVER, false);
            GameParams.INSTANCE.setLastScore(this.score);
            this.lastSbg.enterState(3);
        }
    }

    private float computeImpulseFromHeartBeat(int hb) {
        int coeff = this.currentHeartBeat > this.HEARTBEAT_THRESHOLD_CRAZY ? 9 : (this.currentHeartBeat > this.HEARTBEAT_THRESHOLD_HARD ? 9 : (this.currentHeartBeat > this.HEARTBEAT_THRESHOLD_MEDIUM ? 8 : 6));
        float result = coeff * this.currentHeartBeat;
        return result;
    }

    private void manageInput(GameContainer gc, StateBasedGame sbg, int delta) throws SlickException {
        Input input = gc.getInput();
        if (input.isKeyDown(200) || input.isKeyDown(44) || input.isKeyDown(17)) {
            this.player.moveImpulse(Player.upImpulseVec);
            ((Player)this.player.getSprite()).goUp();
        } else if (input.isKeyDown(208) || input.isKeyDown(31)) {
            this.player.moveImpulse(Player.downImpulseVec);
            ((Player)this.player.getSprite()).goDown();
        } else {
            ((Player)this.player.getSprite()).stop();
        }
        if (input.isKeyPressed(57)) {
            this.playerHeartBeat(delta);
            SoundManager.INSTANCE.playAsSoundEffect(SoundID.HEARTBEAT, 1.0f, 15.0f, false);
        }
        if (input.isMousePressed(0) || input.isKeyPressed(205) || input.isKeyPressed(29)) {
            Laser l = new Laser();
            SoundManager.INSTANCE.playAsSoundEffect(SoundID.LASER1, 1.0f, 0.1f, false);
            if (this.laserTop) {
                l.setCoords((int)this.player.getCoords().getX() + (int)this.scrolledDistance * 10, (int)this.player.getCoords().getY() - 27);
            } else {
                l.setCoords((int)this.player.getCoords().getX() + (int)this.scrolledDistance * 10, (int)this.player.getCoords().getY() + 24);
            }
            this.laserTop = !this.laserTop;
            PhysicsObject phyObj = PhysicsObject.createFromCircSprite(l, this.world);
            this.lasers.add(phyObj);
        }
        this.setChanged();
        this.notifyObserver(this.heartBeatDisplay);
    }

    private void updateObjects() {
        ArrayList<PhysicsObject> toRemove = new ArrayList<PhysicsObject>();
        for (PhysicsObject so : this.objects) {
            so.move(new Vec2(0.0f, 0.0f));
            if (so.getSprite() instanceof Cancer) {
                Vec2 v = this.player.getPhyCoordsVec().sub(so.getPhyCoordsVec());
                v.normalize();
                if (DBG) {
                    System.out.println("Normalized cancer v-vect=" + v);
                }
                so.move(10.0f * v.x, 10.0f * v.y);
            }
            if (!(so.getCoords().getX() < -250.0)) continue;
            toRemove.add(so);
        }
        for (PhysicsObject so : toRemove) {
            this.objects.remove(so);
        }
    }

    private void manageColisions() {
        for (int i = 0; i < this.objects.size(); ++i) {
            if (!this.player.getSprite().boundingBox.intersects(this.objects.get(i).getSprite().getBoundingBox())) continue;
            this.objects.get(i).colideWithPlayer();
        }
        int j = 0;
        while (j < this.lasers.size()) {
            boolean stop = false;
            for (int i = 0; i < this.objects.size(); ++i) {
                stop = false;
                Sprite s = this.objects.get(i).getSprite();
                Laser l = (Laser)this.lasers.get(j).getSprite();
                if (!s.boundingBox.intersects(l.getBoundingBox()) || !(s instanceof Cancer) && !(s instanceof GlobuleBlanc) && !(s instanceof GlobuleRouge) && !(s instanceof Virus)) continue;
                ((Obstacle)s).die();
                this.objects.remove(i);
                this.lasers.remove(j);
                stop = true;
                break;
            }
            if (stop) continue;
            ++j;
        }
    }

    private void removeObjects() {
        int i = 0;
        while (i < this.objects.size()) {
            if (this.objects.get(i).getSprite().needToRemove()) {
                this.objects.remove(i);
                continue;
            }
            ++i;
        }
    }

    private void addObjects() throws SlickException {
        if (this.scrolledDistance > (float)this.nextDistancePopObstacle) {
            this.spawnRandomObject();
            this.nextDistancePopObstacle += this.deltaDistancePopObstacle;
        }
    }

    private void initPhysics() {
        this.gravity = new Vec2(0.0f, 0.0f);
        this.world = new World(this.gravity, true);
        this.playerBodyDef = new BodyDef();
        this.playerBodyDef.type = BodyType.DYNAMIC;
        this.playerBodyDef.position.x = GamePlay.px2m(128);
        this.playerBodyDef.position.y = GamePlay.px2m((int)GamePlay.ySlick2Physics(339.0f));
        this.playerBody = this.world.createBody(this.playerBodyDef);
        this.playerShape = new PolygonShape();
        this.playerShape.setAsBox(GamePlay.px2m(21.0), GamePlay.px2m(21.5));
        this.playerFD = new FixtureDef();
        this.playerFD.shape = this.playerShape;
        this.playerFD.density = 1.0f;
        this.playerFD.friction = 1.5f;
        this.playerBody.setAngularDamping(200.0f);
        this.playerBody.setLinearDamping(1.2f);
        this.playerBody.createFixture(this.playerFD);
        this.timeStep = 0.016666668f;
        this.velocityIterations = 6;
        this.positionIterations = 2;
    }

    public static float ySlick2Physics(float y) {
        return 720.0f - y;
    }

    public static float yFromPhysicsToSlick(float y) {
        return 720.0f - y;
    }

    private void updatePhysics() {
        Vec2 currPos = new Vec2(this.player.getPhyCoordsVec());
        this.world.step(this.timeStep, this.velocityIterations, this.positionIterations);
        this.scrollDelta = this.player.getPhyCoordsVec().x - currPos.x;
        this.scrolledDistance += this.scrollDelta;
        if (DBG) {
            System.out.println("Player=" + this.player.getPhyCoordsVec() + "\t" + this.player.getCoords());
            System.out.println("Scrolled=" + this.scrolledDistance);
        }
        PhysicsObject.setScrolledDistance(this.scrolledDistance);
        if (DBG) {
            for (PhysicsObject po : this.objects) {
                System.out.println(po.getPhyCoords() + "\t" + po.getCoords());
            }
        }
    }

    public static float px2m(int px) {
        return (float)px / 10.0f;
    }

    public static int m2px(float m) {
        return (int)(m * 10.0f);
    }

    private void updateCurrentHB(int delta) {
        Long tenSecondsAgo = new Date().getTime() - (long)(this.heartBeatAvgInterval * 1000);
        int sum = 0;
        int i = 0;
        while (i < this.HBList.size()) {
            Long l = this.HBList.get(i);
            if (l.compareTo(tenSecondsAgo) < 0) {
                this.HBList.remove(i);
                continue;
            }
            ++i;
            ++sum;
        }
        this.currentHeartBeat = (int)((double)sum / (double)this.heartBeatAvgInterval * 60.0);
        if (DBG) {
            System.out.println("currentHeartBeat=" + this.currentHeartBeat);
        }
    }

    private void playerHeartBeat(int delta) {
        this.speedImpulse = new Vec2(this.computeImpulseFromHeartBeat(this.currentHeartBeat), 0.0f);
        this.playerBody.applyLinearImpulse(this.speedImpulse, this.playerBody.getPosition());
        Date date = new Date();
        this.HBList.add(date.getTime());
    }

    public float getScoreModifier() {
        if ((float)this.currentHeartBeat <= GameParams.INSTANCE.BeatThreshold1()) {
            return GameParams.INSTANCE.ScoreModifier1();
        }
        if ((float)this.currentHeartBeat > GameParams.INSTANCE.BeatThreshold1() && (float)this.currentHeartBeat <= GameParams.INSTANCE.BeatThreshold2()) {
            return GameParams.INSTANCE.ScoreModifier2();
        }
        if ((float)this.currentHeartBeat > GameParams.INSTANCE.BeatThreshold2() && (float)this.currentHeartBeat <= GameParams.INSTANCE.BeatThreshold3()) {
            return GameParams.INSTANCE.ScoreModifier3();
        }
        if ((float)this.currentHeartBeat > GameParams.INSTANCE.BeatThreshold3() && (float)this.currentHeartBeat <= GameParams.INSTANCE.BeatThreshold4()) {
            return GameParams.INSTANCE.ScoreModifier4();
        }
        return GameParams.INSTANCE.ScoreModifier5();
    }

    private void updateLasers() {
        for (PhysicsObject po : this.lasers) {
            po.getBody().setTransform(new Vec2(po.getBody().getPosition().x + 3.0f, po.getBody().getPosition().y), 0.0f);
        }
    }

    private void updateSplashes() {
        for (int i = 0; i < this.splashes.size(); ++i) {
            if (this.splashes.get((int)i).staticA.isStopped()) {
                this.splashes.remove(i);
                continue;
            }
            ++i;
        }
    }

    public void addLife(int dLife) {
        this.life += (float)dLife;
        if (this.life < 0.0f) {
            this.life = 0.0f;
        } else if (this.life > (float)GameParams.INSTANCE.MaxLife()) {
            this.life = GameParams.INSTANCE.MaxLife();
        }
        this.setChanged();
        this.notifyObserver(this.lifeDisplay);
    }

    public void addScore(int dScore) {
        this.score += dScore;
        this.setChanged();
        this.notifyObserver(this.scoreDisplay);
    }

    private void spawnRandomObject() throws SlickException {
        Obstacle o = Obstacle.getRandomObstacle();
        o.setCoords(1580 + GamePlay.m2px(this.scrolledDistance), (int)(Math.random() * 720.0));
        PhysicsObject phyObj = PhysicsObject.createFromCircSprite(o, this.world);
        this.objects.add(phyObj);
    }

    public int getScore() {
        return this.score;
    }

    public float getLife() {
        return this.life;
    }

    public float getHeartBeat() {
        return this.bloodSpeed;
    }

    public int getCurrentHeartBeat() {
        return this.currentHeartBeat;
    }

    @Override
    public void addObserver(IObserver o) {
        this.observers.add(o);
    }

    @Override
    public int countObservers() {
        return this.observers.size();
    }

    @Override
    public void deleteObserver(IObserver o) {
        this.observers.remove(o);
    }

    @Override
    public void deleteObservers(IObserver o) {
        this.observers.clear();
    }

    @Override
    public boolean hasChanged() {
        return this.hasChanged;
    }

    @Override
    public void notifyObserver(IObserver o) {
        if (this.hasChanged() && this.observers.indexOf(o) != -1) {
            this.observers.get(this.observers.indexOf(o)).update(this, null);
            this.clearChanged();
        }
    }

    @Override
    public void notifyObservers() {
        if (this.hasChanged()) {
            for (IObserver obs : this.observers) {
                obs.update(this, null);
            }
            this.clearChanged();
        }
    }

    protected void clearChanged() {
        this.hasChanged = false;
    }

    public void setChanged() {
        this.hasChanged = true;
    }

    static float px2m(double x) {
        return GamePlay.px2m((int)x);
    }

    class Pair<T1, T2> {
        public T1 first;
        public T2 second;

        Pair() {
        }
    }
}

