/*
 * Decompiled with CFR 0.152.
 */
package nanoblood;

import java.awt.geom.Point2D;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import nanoblood.CollisionsCollection;
import nanoblood.LevelSegment;
import nanoblood.Sprite;
import org.jbox2d.dynamics.World;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.StateBasedGame;

public class LevelManager {
    public static final int[] SEGMENT_IDS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
    public static final int SEGMENT_X_OFFSET = 48;
    private static final double BG_PARALLAX_MODIFIER = 0.1;
    private static final String BG_IMAGE = "sprites/map/Background.jpg";
    private LinkedList<LevelSegment> segmentsStack;
    private LinkedList<LevelSegment> bgStack;
    private Image lightning;
    private Image blackFxImage;
    private final World w;
    private float scrolledDistance;
    private static int foregroundLoadingCounter = 0;

    public static int getForegroundLoadingCounter() {
        return foregroundLoadingCounter;
    }

    private void pushNewSegmentsStack(LevelSegment s) {
        this.segmentsStack.add(s);
        this.collisionsToSegment(s);
        ++foregroundLoadingCounter;
    }

    public LevelManager(World w) throws SlickException, FileNotFoundException {
        this.w = w;
        this.segmentsStack = new LinkedList();
        LevelSegment initSegment = new LevelSegment("sprites/map/MAP_1.png", false, w);
        this.pushNewSegmentsStack(initSegment);
        LevelSegment newSegment = this.selectNextSegment();
        newSegment.setCoords(new Point2D.Float(1232.0f, 0.0f));
        this.pushNewSegmentsStack(newSegment);
        this.bgStack = new LinkedList();
        this.bgStack.add(new LevelSegment(BG_IMAGE, false, w));
        this.lightning = Sprite.getImage("sprites/fx/Lightning.png");
        this.lightning = Sprite.getImage("sprites/fx/Lightning.png");
        this.blackFxImage = Sprite.getImage("sprites/fx/BlackFX.png");
        this.blackFxImage.setAlpha(0.0f);
    }

    public void update(double deltaPixels, float scrolledDistance) throws SlickException, FileNotFoundException {
        LevelSegment headSegment;
        this.scrolledDistance = scrolledDistance;
        if (deltaPixels <= 0.0) {
            return;
        }
        if (!this.segmentsStack.isEmpty()) {
            headSegment = this.segmentsStack.peek();
            float headTopLeftX = (float)headSegment.getCoords().getX();
            float headTopRightX = (float)(headSegment.getCoords().getX() + 1280.0);
            if (this.segmentsStack.size() <= 2 && headTopRightX <= 96.0f) {
                LevelSegment newSegment = this.selectNextSegment();
                this.collisionsToSegment(newSegment);
                newSegment.setCoords(new Point2D.Float((float)(1280 * this.segmentsStack.size()) + headTopLeftX - 96.0f, 0.0f));
                this.pushNewSegmentsStack(newSegment);
            } else if (headTopLeftX <= -1328.0f) {
                headSegment.goodBye(this.w);
                this.segmentsStack.remove();
            }
        }
        for (LevelSegment segment : this.segmentsStack) {
            segment.addToX(-deltaPixels);
        }
        if (!this.bgStack.isEmpty()) {
            headSegment = this.bgStack.peek();
            float headX = (float)headSegment.getCoords().getX();
            if (headX <= 0.0f && this.bgStack.size() < 2) {
                LevelSegment newSegment = new LevelSegment(BG_IMAGE, false, null);
                newSegment.setCoords(new Point2D.Float((float)(1280 * this.bgStack.size()) + headX, 0.0f));
                this.bgStack.add(newSegment);
            } else if (headX <= -1280.0f) {
                this.bgStack.remove();
            }
        }
        for (LevelSegment bg : this.bgStack) {
            bg.addToX((int)(-deltaPixels * 0.1));
        }
    }

    public void render(GameContainer gc, StateBasedGame sbg, Graphics gr) {
        for (LevelSegment bg : this.bgStack) {
            bg.getRenderable().draw((float)bg.getCoords().getX(), (float)bg.getCoords().getY());
        }
        for (LevelSegment segment : this.segmentsStack) {
            segment.getRenderable().draw((float)segment.getCoords().getX(), (float)segment.getCoords().getY());
        }
        if (this.blackFxImage.getAlpha() > 0.0f) {
            this.blackFxImage.draw(0.0f, 0.0f);
        }
        this.lightning.draw(0.0f, 0.0f, 1280.0f, 720.0f);
    }

    private LevelSegment selectNextSegment() throws SlickException, FileNotFoundException {
        int segmentId = SEGMENT_IDS[(int)Math.floor(Math.random() * (double)SEGMENT_IDS.length)];
        boolean isFlippedHorizontally = false;
        return new LevelSegment("sprites/map/MAP_" + segmentId + ".png", isFlippedHorizontally, this.w);
    }

    public void setBlackFxAlpha(float alpha) {
        this.blackFxImage.setAlpha(alpha);
    }

    private void collisionsToSegment(LevelSegment newSegment) {
        CollisionsCollection cc = newSegment.getCC();
        if (null != cc) {
            cc.injectIntoWorld(this.w, this.scrolledDistance);
        }
    }
}

