/*
 * Decompiled with CFR 0.152.
 */
package nanoblood;

import nanoblood.Sprite;
import nanoblood.sound.SoundID;
import nanoblood.sound.SoundManager;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.gui.AbstractComponent;
import org.newdawn.slick.gui.ComponentListener;
import org.newdawn.slick.gui.MouseOverArea;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;

public class MainMenu
extends BasicGameState
implements ComponentListener {
    int stateID = -1;
    Image bg;
    private MouseOverArea soundCurrent;
    private MouseOverArea soundOn;
    private MouseOverArea soundOff;
    private MouseOverArea play;
    private MouseOverArea tuto;
    private Image soundOffImg;
    private Image soundOnImg;
    private GameContainer lastgc;
    private StateBasedGame lastsbg;
    private Image bg2;
    private Image credits;
    private boolean lightOn = false;

    MainMenu(int stateID) {
        this.stateID = stateID;
    }

    @Override
    public int getID() {
        return this.stateID;
    }

    @Override
    public void init(GameContainer gc, StateBasedGame sbg) throws SlickException {
        this.bg = new Image("sprites/main_menu.jpg");
        this.bg2 = new Image("sprites/little_lights.png");
        this.credits = new Image("sprites/credits.png");
        this.soundOffImg = Sprite.getImage("sprites/sound_menu_OFF.png");
        this.soundOnImg = Sprite.getImage("sprites/sound_menu_ON.png");
        this.soundOn = new MouseOverArea(gc, this.soundOnImg, 1024, 576, this);
        this.soundOff = new MouseOverArea(gc, this.soundOffImg, 1024, 576, this);
        this.soundCurrent = this.soundOn;
        this.play = new MouseOverArea(gc, Sprite.getImage("sprites/play.png"), 575, 180, this);
        this.play.setMouseOverImage(Sprite.getImage("sprites/play_mouseover.png"));
        this.tuto = new MouseOverArea(gc, Sprite.getImage("sprites/tuto.png"), 192, 103, this);
        this.tuto.setMouseOverImage(Sprite.getImage("sprites/tuto_mouseover.png"));
        SoundManager.INSTANCE.playAsMusic(SoundID.MENU, true);
    }

    @Override
    public void render(GameContainer gc, StateBasedGame sbg, Graphics grphcs) throws SlickException {
        this.bg.draw(0.0f, 0.0f);
        this.soundCurrent.render(gc, grphcs);
        this.play.render(gc, grphcs);
        this.tuto.render(this.lastgc, grphcs);
        if (this.lightOn) {
            this.bg2.draw(0.0f, 0.0f);
        }
        this.credits.draw(25.0f, (float)(720 - this.credits.getHeight() - 25), (float)this.credits.getWidth(), this.credits.getHeight());
    }

    @Override
    public void update(GameContainer gc, StateBasedGame sbg, int i) throws SlickException {
        this.lastgc = gc;
        this.lastsbg = sbg;
        if (this.play.isMouseOver() || this.tuto.isMouseOver()) {
            this.lightOn = true;
            if (!SoundManager.INSTANCE.isPlaying(SoundID.SELECT)) {
                SoundManager.INSTANCE.playAsSoundEffect(SoundID.SELECT, false);
            }
        } else {
            this.lightOn = false;
        }
    }

    @Override
    public void componentActivated(AbstractComponent source) {
        if (this.soundCurrent == source) {
            if (!SoundManager.INSTANCE.isMuted()) {
                SoundManager.INSTANCE.setMuted(true);
                this.soundCurrent = this.soundOff;
            } else {
                SoundManager.INSTANCE.setMuted(false);
                this.soundCurrent = this.soundOn;
            }
        } else if (this.play == source) {
            SoundManager.INSTANCE.stopSound(SoundID.MENU);
            SoundManager.INSTANCE.playAsSoundEffect(SoundID.PLAY, false);
            SoundManager.INSTANCE.playAsMusic(SoundID.THEME, 1.0f, -20.0f, true);
            this.lastsbg.enterState(2);
        } else if (this.tuto == source) {
            this.lastsbg.enterState(4);
            SoundManager.INSTANCE.playAsSoundEffect(SoundID.PLAY, false);
        }
    }
}

