/*
 * Decompiled with CFR 0.152.
 */
package nanoblood;

import java.awt.geom.Point2D;
import nanoblood.GamePlay;
import nanoblood.Sprite;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.World;
import org.newdawn.slick.Renderable;

public class PhysicsObject {
    private static float scrolledDistance = 0.0f;
    private final Sprite sprite;
    private final Body body;

    static void setScrolledDistance(float scrolledDistance) {
        PhysicsObject.scrolledDistance = scrolledDistance;
    }

    public Sprite getSprite() {
        return this.sprite;
    }

    public Body getBody() {
        return this.body;
    }

    public Point2D getPhyCoords() {
        Point2D.Double tmp = new Point2D.Double(){};
        ((Point2D)tmp).setLocation(this.body.getPosition().x, this.body.getPosition().x);
        return tmp;
    }

    public Point2D getCoords() {
        Point2D.Double tmp = new Point2D.Double();
        Vec2 pos = this.body.getPosition();
        ((Point2D)tmp).setLocation(GamePlay.m2px(pos.x - scrolledDistance), GamePlay.yFromPhysicsToSlick(GamePlay.m2px(pos.y)));
        return tmp;
    }

    public Vec2 getPhyCoordsVec() {
        return this.body.getPosition();
    }

    public void move(Vec2 v) {
        this.body.setLinearVelocity(v);
    }

    public void move(float x, float y) {
        this.move(new Vec2(x, y));
    }

    PhysicsObject(Sprite s, Body b) {
        this.body = b;
        this.sprite = s;
    }

    public Renderable getRenderable() {
        Vec2 pos = this.body.getPosition();
        this.sprite.boundingBox.setX(GamePlay.m2px(pos.x));
        this.sprite.boundingBox.setY(GamePlay.yFromPhysicsToSlick(GamePlay.m2px(pos.y)));
        return this.sprite.getRenderable();
    }

    public void colideWithPlayer() {
        this.sprite.colideWithPlayer();
    }

    public void colide(Sprite s) {
        this.sprite.colide(s);
    }

    public static PhysicsObject createFromCircSprite(Sprite s, World w) {
        BodyDef bdef = new BodyDef();
        bdef.type = BodyType.DYNAMIC;
        bdef.position.x = GamePlay.px2m(s.getCoords().getX());
        bdef.position.y = GamePlay.px2m((int)GamePlay.ySlick2Physics((float)s.getCoords().getY()));
        Body b = w.createBody(bdef);
        CircleShape shape = new CircleShape();
        shape.m_radius = GamePlay.px2m(s.boundingBox.getHeight());
        FixtureDef fd = new FixtureDef();
        fd.shape = shape;
        fd.density = 1.0f;
        return new PhysicsObject(s, b);
    }

    public static PhysicsObject createFromRectSprite(Sprite s, World w) {
        BodyDef bdef = new BodyDef();
        bdef.type = BodyType.DYNAMIC;
        bdef.position.x = GamePlay.px2m(s.getCoords().getX());
        bdef.position.y = GamePlay.px2m((int)GamePlay.ySlick2Physics((float)s.getCoords().getY()));
        Body b = w.createBody(bdef);
        PolygonShape shape = new PolygonShape();
        shape.setAsBox(GamePlay.px2m(s.boundingBox.getWidth()), GamePlay.px2m(s.boundingBox.getWidth()));
        FixtureDef fd = new FixtureDef();
        fd.shape = shape;
        fd.density = 1.0f;
        b.createFixture(fd);
        return new PhysicsObject(s, b);
    }

    void moveImpulse(Vec2 v) {
        this.body.applyLinearImpulse(v, this.body.getPosition());
    }
}

