/*
 * Decompiled with CFR 0.152.
 */
package nanoblood;

import java.util.Date;
import nanoblood.Sprite;
import nanoblood.sound.SoundID;
import nanoblood.sound.SoundManager;
import org.jbox2d.common.Vec2;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Image;
import org.newdawn.slick.Renderable;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Circle;

public class Player
extends Sprite {
    protected static final Vec2 upImpulseVec = new Vec2(0.0f, 70.0f);
    protected static final Vec2 downImpulseVec = new Vec2(0.0f, -70.0f);
    protected static final float INIT_X = 128.0f;
    protected static final float WIDTH = 42.0f;
    protected static final float INIT_Y = 339.0f;
    protected static final float HEIGHT = 43.0f;
    Anim currentAnim;
    Image staticShip = Sprite.getImage("sprites/player/static.png");
    Animation downGo;
    Animation downBack;
    Animation upGo;
    Animation upBack;
    Animation shield;
    boolean shieldActivated = false;
    Date lastShieldActivation = null;
    int shieldSeconds = 2;
    Image canons = Sprite.getImage("sprites/player/canons.png");
    final int VERTICAL_SPEED = 8;

    public int getWidth() {
        return this.staticShip.getWidth();
    }

    public int getHeight() {
        return this.staticShip.getHeight();
    }

    public Player() throws SlickException {
        int i;
        this.canons.rotate(90.0f);
        this.boundingBox = new Circle((int)this.coords.getX() + 50, (int)this.coords.getY() + 50, 25.0f);
        Image[] anim = new Image[5];
        for (i = 0; i < anim.length; ++i) {
            anim[i] = Sprite.getImage("sprites/player/goYUp/mainperso_mouvementx-_" + Sprite.intToString(i, 5) + ".png");
        }
        this.upGo = new Animation(anim, 50, true);
        this.upGo.setLooping(false);
        anim = new Image[5];
        for (i = 0; i < anim.length; ++i) {
            anim[i] = Sprite.getImage("sprites/player/backYUp/mainperso_mouvementx-_" + Sprite.intToString(i, 5) + ".png");
        }
        this.upBack = new Animation(anim, 50, true);
        this.upBack.setLooping(false);
        anim = new Image[5];
        for (i = 0; i < anim.length; ++i) {
            anim[i] = Sprite.getImage("sprites/player/goYDown/mainperso_mouvementx+_" + Sprite.intToString(i, 5) + ".png");
        }
        this.downGo = new Animation(anim, 50, true);
        this.downGo.setLooping(false);
        anim = new Image[5];
        for (i = 0; i < anim.length; ++i) {
            anim[i] = Sprite.getImage("sprites/player/backYDown/mainperso_mouvementx+_" + Sprite.intToString(i, 5) + ".png");
        }
        this.downBack = new Animation(anim, 50, true);
        this.downBack.setLooping(false);
        anim = new Image[20];
        for (i = 0; i < anim.length; ++i) {
            anim[i] = Sprite.getImage("sprites/obstacles/BOUCLIER/Shield" + Sprite.intToString(i, 5) + ".png");
        }
        this.shield = new Animation(anim, 50, true);
        this.shield.start();
        this.currentAnim = Anim.STATIC;
    }

    @Override
    public Renderable getRenderable() {
        switch (this.currentAnim) {
            case UP_GO: {
                return this.upGo;
            }
            case UP_BACK: {
                return this.upBack;
            }
            case DOWN_GO: {
                return this.downGo;
            }
            case DOWN_BACK: {
                return this.downBack;
            }
        }
        return this.staticShip;
    }

    public void goUp() {
        if (this.currentAnim != Anim.UP_GO && this.upGo.isStopped()) {
            this.upBack.stop();
            this.downGo.stop();
            this.downBack.stop();
            this.upGo.restart();
            this.currentAnim = Anim.UP_GO;
        }
    }

    public void goDown() {
        if (this.currentAnim != Anim.DOWN_GO && this.downGo.isStopped()) {
            this.upGo.stop();
            this.upBack.stop();
            this.downBack.stop();
            this.downGo.restart();
            this.currentAnim = Anim.DOWN_GO;
        }
    }

    public void stop() {
        this.upGo.stop();
        this.downGo.stop();
        if (this.currentAnim == Anim.UP_GO) {
            this.currentAnim = Anim.UP_BACK;
            this.upBack.restart();
        } else if (this.currentAnim == Anim.DOWN_GO) {
            this.currentAnim = Anim.DOWN_BACK;
            this.downBack.restart();
        }
    }

    public void activateShield(boolean active) {
        this.shieldActivated = active;
        if (active) {
            this.lastShieldActivation = new Date();
            SoundManager.INSTANCE.playAsSoundEffect(SoundID.BONUS, 1.0f, 0.4f, true);
        }
    }

    public boolean isShieldActivated() {
        Date d;
        float r;
        if (this.shieldActivated && (r = (float)((long)(this.shieldSeconds * 1000) - ((d = new Date()).getTime() - this.lastShieldActivation.getTime()))) <= 0.0f) {
            this.shieldActivated = false;
            SoundManager.INSTANCE.stopSound(SoundID.BONUS);
        }
        return this.shieldActivated;
    }

    public Image getCanons() {
        return this.canons;
    }

    private static enum Anim {
        STATIC,
        UP_GO,
        UP_BACK,
        DOWN_GO,
        DOWN_BACK;

    }
}

