/*
 * Decompiled with CFR 0.152.
 */
package nanoblood;

import nanoblood.Obstacle;
import nanoblood.Sprite;
import nanoblood.sound.SoundID;
import nanoblood.sound.SoundManager;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Image;
import org.newdawn.slick.Renderable;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Circle;

public class Splash
extends Obstacle {
    Anim currentAnim;
    Animation staticA;

    public Splash() throws SlickException {
        this.boundingBox = new Circle((int)this.coords.getX() + 50, (int)this.coords.getY() + 50, 1.0f);
        Image[] anim = new Image[20];
        for (int i = 0; i < anim.length; ++i) {
            anim[i] = Sprite.getImage("sprites/splashseq/splashbrut" + Sprite.intToString(i, 4) + ".png");
        }
        this.staticA = new Animation(anim, 30, true);
        this.staticA.setLooping(false);
        int splashID = (int)Math.floor(Math.random() * 3.0);
        switch (splashID) {
            default: {
                SoundManager.INSTANCE.playAsSoundEffect(SoundID.SPLASH1, 1.0f, 0.1f, false);
                break;
            }
            case 1: {
                SoundManager.INSTANCE.playAsSoundEffect(SoundID.SPLASH2, 1.0f, 0.1f, false);
                break;
            }
            case 2: {
                SoundManager.INSTANCE.playAsSoundEffect(SoundID.SPLASH3, 1.0f, 0.1f, false);
            }
        }
        this.currentAnim = Anim.STATIC;
    }

    @Override
    public Renderable getRenderable() {
        switch (this.currentAnim) {
            case STATIC: {
                return this.staticA;
            }
        }
        return this.staticA;
    }

    @Override
    public void colideWithPlayer() {
    }

    private static enum Anim {
        STATIC;

    }
}

