/*
 * Decompiled with CFR 0.152.
 */
package nanoblood;

import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.newdawn.slick.Image;
import org.newdawn.slick.Renderable;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Shape;

public abstract class Sprite {
    private static Map<String, Image> sprites = new TreeMap<String, Image>();
    protected Point2D coords = new Point2D.Double();
    protected Shape boundingBox;
    protected boolean remove = false;

    public static Image getImage(String path) throws SlickException {
        if (sprites.containsKey(path)) {
            return sprites.get(path);
        }
        Image i = new Image(path);
        sprites.put(path, i);
        return i;
    }

    public static String intToString(int num, int digits) {
        assert (digits > 0) : "Invalid number of digits";
        char[] zeros = new char[digits];
        Arrays.fill(zeros, '0');
        DecimalFormat df = new DecimalFormat(String.valueOf(zeros));
        return df.format(num);
    }

    public boolean colide(Sprite s) {
        return this.boundingBox.intersects(s.boundingBox);
    }

    public abstract Renderable getRenderable();

    public Point2D getCoords() {
        return this.coords;
    }

    public void setCoords(Point2D coords) {
        this.coords = coords;
    }

    public void setCoords(int x, int y) {
        this.boundingBox.setX((float)x + (this.boundingBox.getX() - (float)((int)this.coords.getX())));
        this.boundingBox.setY((float)y + (this.boundingBox.getY() - (float)((int)this.coords.getY())));
        this.coords.setLocation(x, y);
    }

    public Shape getBoundingBox() {
        return this.boundingBox;
    }

    public void colideWithPlayer() {
        this.remove = true;
    }

    public boolean needToRemove() {
        return this.remove;
    }
}

