/*
 * Decompiled with CFR 0.152.
 */
package nanoblood.sound;

import java.io.IOException;
import nanoblood.sound.SoundID;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.openal.SoundStore;

public enum SoundManager {
    INSTANCE;

    private boolean isMuted = false;
    private SoundStore ss = SoundStore.get();
    private Audio audioBonus;
    private Audio audioHeartBeat;
    private Audio audioMenu;
    private Audio audioPlay;
    private Audio audioSelect;
    private Audio audioSplash1;
    private Audio audioSplash2;
    private Audio audioSplash3;
    private Audio audioLifeUp;
    private Audio audioGameOver;
    private Audio audioLaser1;
    private Audio audioLaser2;
    private Audio audioTheme;

    private SoundManager() {
        this.ss.init();
        try {
            this.audioBonus = this.ss.getOgg("sounds/bonus1.ogg");
            this.audioHeartBeat = this.ss.getWAV("sounds/coeur_1.wav");
            this.audioMenu = this.ss.getOgg("sounds/mainmenu.ogg");
            this.audioPlay = this.ss.getOgg("sounds/play.ogg");
            this.audioSelect = this.ss.getOgg("sounds/select.ogg");
            this.audioSplash1 = this.ss.getOgg("sounds/splash1.ogg");
            this.audioSplash2 = this.ss.getOgg("sounds/splash2.ogg");
            this.audioSplash3 = this.ss.getOgg("sounds/splash3.ogg");
            this.audioLifeUp = this.ss.getOgg("sounds/lifeup.ogg");
            this.audioGameOver = this.ss.getOgg("sounds/gameover.ogg");
            this.audioLaser1 = this.ss.getOgg("sounds/lasershot1.ogg");
            this.audioLaser2 = this.ss.getOgg("sounds/lasershot2.ogg");
            this.audioTheme = this.ss.getOgg("sounds/theme_2.ogg");
            this.ss.setMusicVolume(0.15f);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public SoundStore getSoundStore() {
        return this.ss;
    }

    public void setMuted(boolean isMuted) {
        this.isMuted = isMuted;
        this.ss.setSoundsOn(!isMuted);
        this.ss.setMusicOn(!isMuted);
    }

    public boolean isMuted() {
        return this.isMuted;
    }

    private Audio getAudio(SoundID id) {
        switch (id) {
            case BONUS: {
                return this.audioBonus;
            }
            case HEARTBEAT: {
                return this.audioHeartBeat;
            }
            case MENU: {
                return this.audioMenu;
            }
            case PLAY: {
                return this.audioPlay;
            }
            case SELECT: {
                return this.audioSelect;
            }
            case SPLASH1: {
                return this.audioSplash1;
            }
            case SPLASH2: {
                return this.audioSplash2;
            }
            case SPLASH3: {
                return this.audioSplash3;
            }
            case LIFEUP: {
                return this.audioLifeUp;
            }
            case GAMEOVER: {
                return this.audioGameOver;
            }
            case LASER1: {
                return this.audioLaser1;
            }
            case LASER2: {
                return this.audioLaser2;
            }
            case THEME: {
                return this.audioTheme;
            }
        }
        return null;
    }

    public void playAsMusic(SoundID id, boolean isLooped) {
        this.getAudio(id).playAsMusic(1.0f, 1.0f, isLooped);
    }

    public void playAsMusic(SoundID id, float pitch, float gain, boolean isLooped) {
        this.getAudio(id).playAsMusic(pitch, gain, isLooped);
    }

    public void playAsSoundEffect(SoundID id, float pitch, float gain, boolean isLooped) {
        this.getAudio(id).playAsSoundEffect(pitch, gain, isLooped);
    }

    public void playAsSoundEffect(SoundID id, boolean isLooped) {
        this.getAudio(id).playAsSoundEffect(1.0f, 1.0f, isLooped);
    }

    public void stopSound(SoundID id) {
        this.getAudio(id).stop();
    }

    public boolean isPlaying(SoundID id) {
        return this.getAudio(id).isPlaying();
    }
}

