/*
 * Decompiled with CFR 0.152.
 */
package nanoblood.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import nanoblood.GamePlay;
import nanoblood.Sprite;
import nanoblood.util.GameParams;
import nanoblood.util.IObservable;
import nanoblood.util.IObserver;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.UnicodeFont;
import org.newdawn.slick.font.effects.ColorEffect;
import org.newdawn.slick.font.effects.OutlineEffect;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.util.ResourceLoader;

public class HeartBeatDisplay
implements IObserver {
    private static final int X_OFFSET = 20;
    private static final int Y_OFFSET = 20;
    public static final int CONTENT_WIDTH = 209;
    public static final int CONTENT_HEIGHT = 21;
    public static final int CONTENT_X_OFFSET = 83;
    public static final int CONTENT_Y_OFFSET = 11;
    private float heartBeat = 0.0f;
    private Image heartBeatBackground = Sprite.getImage("sprites/ui/HeartBar.png");
    private Image cursorImage = Sprite.getImage("sprites/ui/HeartBarCursor.png");
    private float scoreModifier = 0.0f;
    private UnicodeFont unicodeFont;
    private int cursor1;
    private int cursor2;
    private int cursor3;
    private int cursor4;

    public HeartBeatDisplay() throws SlickException {
        Font javaFont = null;
        try {
            javaFont = Font.createFont(0, ResourceLoader.getResourceAsStream("fonts/LCD_Mono_Normal.ttf"));
        }
        catch (FontFormatException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.unicodeFont = new UnicodeFont(javaFont, 32, false, false);
        this.unicodeFont.getEffects().add(new ColorEffect(Color.white));
        this.unicodeFont.getEffects().add(new OutlineEffect(3, new Color(0, 255, 100, 64)));
        this.unicodeFont.addGlyphs("0123456789 x.");
        this.unicodeFont.loadGlyphs();
        this.cursor1 = (int)(103.0f + GameParams.INSTANCE.BeatThreshold1() * 209.0f / GameParams.INSTANCE.MaxBeat());
        this.cursor2 = (int)(103.0f + GameParams.INSTANCE.BeatThreshold2() * 209.0f / GameParams.INSTANCE.MaxBeat());
        this.cursor3 = (int)(103.0f + GameParams.INSTANCE.BeatThreshold3() * 209.0f / GameParams.INSTANCE.MaxBeat());
        this.cursor4 = (int)(103.0f + GameParams.INSTANCE.BeatThreshold4() * 209.0f / GameParams.INSTANCE.MaxBeat());
    }

    @Override
    public void update(IObservable obs, Object obj) {
        if (obs instanceof GamePlay) {
            this.heartBeat = ((GamePlay)obs).getCurrentHeartBeat();
            this.scoreModifier = ((GamePlay)obs).getScoreModifier();
        }
    }

    public void render(GameContainer gc, StateBasedGame sbg, Graphics gr) {
        this.heartBeatBackground.draw(20.0f, 660.0f);
        int x = 103;
        int y = 671;
        gr.setColor(new org.newdawn.slick.Color(255, 0, 0, 128));
        gr.fillRect(x, y, this.cursor1 - x, 21.0f);
        gr.setColor(new org.newdawn.slick.Color(255, 255, 0, 128));
        gr.fillRect(this.cursor1, y, this.cursor2 - this.cursor1, 21.0f);
        gr.setColor(new org.newdawn.slick.Color(0, 255, 0, 128));
        gr.fillRect(this.cursor2, y, this.cursor3 - this.cursor2, 21.0f);
        gr.setColor(new org.newdawn.slick.Color(255, 255, 0, 128));
        gr.fillRect(this.cursor3, y, this.cursor4 - this.cursor3, 21.0f);
        gr.setColor(new org.newdawn.slick.Color(255, 0, 0, 128));
        gr.fillRect(this.cursor4, y, x + 209 - this.cursor4, 21.0f);
        if (this.heartBeat >= 0.0f && this.heartBeat <= GameParams.INSTANCE.MaxBeat()) {
            int hbCursorPos = (int)(this.heartBeat * 209.0f / GameParams.INSTANCE.MaxBeat());
            gr.setColor(new org.newdawn.slick.Color(0, 255, 100));
            gr.drawLine(103 + hbCursorPos, y, 103 + hbCursorPos, y + 21);
        }
        this.cursorImage.draw((float)(this.cursor1 - 8), (float)(y + 16), 16.0f, 16.0f);
        this.cursorImage.draw((float)(this.cursor2 - 8), (float)(y + 16), 16.0f, 16.0f);
        this.cursorImage.draw((float)(this.cursor3 - 8), (float)(y + 16), 16.0f, 16.0f);
        this.cursorImage.draw((float)(this.cursor4 - 8), (float)(y + 16), 16.0f, 16.0f);
        String scoreText = "x " + this.scoreModifier;
        gr.setColor(org.newdawn.slick.Color.white);
        gr.setFont(this.unicodeFont);
        gr.drawString(scoreText, 329.0f, 665.0f);
    }
}

