/*
 * Decompiled with CFR 0.152.
 */
package nanoblood.ui;

import nanoblood.GamePlay;
import nanoblood.Sprite;
import nanoblood.util.GameParams;
import nanoblood.util.IObservable;
import nanoblood.util.IObserver;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.StateBasedGame;

public class LifeDisplay
implements IObserver {
    private static final int X_OFFSET = 20;
    private static final int Y_OFFSET = 20;
    public static final int CONTENT_WIDTH = 290;
    public static final int CONTENT_HEIGHT = 34;
    public static final int CONTENT_X_OFFSET = 96;
    public static final int CONTENT_Y_OFFSET = 11;
    private float life = 0.0f;
    private Image lifeBarBackground = Sprite.getImage("sprites/ui/LifeBar.png");

    @Override
    public void update(IObservable obs, Object obj) {
        if (obs instanceof GamePlay) {
            this.life = ((GamePlay)obs).getLife();
        }
    }

    public void render(GameContainer gc, StateBasedGame sbg, Graphics gr) {
        this.lifeBarBackground.draw(20.0f, 20.0f);
        int maxLife = GameParams.INSTANCE.MaxLife();
        if (this.life >= 0.0f && this.life < (float)maxLife) {
            int width = (int)(((float)maxLife - this.life) * 290.0f / (float)maxLife);
            gr.setColor(Color.black);
            gr.fillRect(406 - width, 31.0f, width, 34.0f);
        }
    }
}

