/*
 * Decompiled with CFR 0.152.
 */
package nanoblood.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import nanoblood.GamePlay;
import nanoblood.util.IObservable;
import nanoblood.util.IObserver;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.UnicodeFont;
import org.newdawn.slick.font.effects.ColorEffect;
import org.newdawn.slick.font.effects.OutlineEffect;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.util.ResourceLoader;

public class ScoreDisplay
implements IObserver {
    private static final int X_OFFSET = 20;
    private static final int Y_OFFSET = 20;
    private int score = 0;
    private UnicodeFont unicodeFont;

    public ScoreDisplay() throws SlickException {
        Font javaFont = null;
        try {
            javaFont = Font.createFont(0, ResourceLoader.getResourceAsStream("fonts/LCD_Mono_Normal.ttf"));
        }
        catch (FontFormatException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.unicodeFont = new UnicodeFont(javaFont, 72, false, false);
        this.unicodeFont.getEffects().add(new ColorEffect(Color.white));
        this.unicodeFont.getEffects().add(new OutlineEffect(4, new Color(0, 255, 100, 64)));
        this.unicodeFont.addGlyphs("0123456789 pts");
        this.unicodeFont.loadGlyphs();
    }

    @Override
    public void update(IObservable obs, Object obj) {
        if (obs instanceof GamePlay) {
            this.score = ((GamePlay)obs).getScore();
        }
    }

    public void render(GameContainer gc, StateBasedGame sbg, Graphics gr) {
        String scoreText = this.score + " pts";
        int textWidth = this.unicodeFont.getWidth(scoreText);
        gr.setColor(org.newdawn.slick.Color.white);
        gr.setFont(this.unicodeFont);
        gr.drawString(scoreText, 1260 - textWidth, 20.0f);
    }
}

