/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.Manifold;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;

public class WorldManifold {
    public final Vec2 normal;
    public final Vec2[] points;
    private final Vec2 pool3 = new Vec2();
    private final Vec2 pool4 = new Vec2();

    public WorldManifold() {
        this.normal = new Vec2();
        this.points = new Vec2[Settings.maxManifoldPoints];
        for (int i = 0; i < Settings.maxManifoldPoints; ++i) {
            this.points[i] = new Vec2();
        }
    }

    public final void initialize(Manifold manifold, Transform xfA, float radiusA, Transform xfB, float radiusB) {
        if (manifold.pointCount == 0) {
            return;
        }
        switch (manifold.type) {
            case CIRCLES: {
                Vec2 pointA = this.pool3;
                Vec2 pointB = this.pool4;
                this.normal.x = 1.0f;
                this.normal.y = 0.0f;
                pointA.x = xfA.position.x + xfA.R.col1.x * manifold.localPoint.x + xfA.R.col2.x * manifold.localPoint.y;
                pointA.y = xfA.position.y + xfA.R.col1.y * manifold.localPoint.x + xfA.R.col2.y * manifold.localPoint.y;
                pointB.x = xfB.position.x + xfB.R.col1.x * manifold.points[0].localPoint.x + xfB.R.col2.x * manifold.points[0].localPoint.y;
                pointB.y = xfB.position.y + xfB.R.col1.y * manifold.points[0].localPoint.x + xfB.R.col2.y * manifold.points[0].localPoint.y;
                if (MathUtils.distanceSquared(pointA, pointB) > 1.4210855E-14f) {
                    this.normal.x = pointB.x - pointA.x;
                    this.normal.y = pointB.y - pointA.y;
                    this.normal.normalize();
                }
                float cAx = this.normal.x * radiusA + pointA.x;
                float cAy = this.normal.y * radiusA + pointA.y;
                float cBx = -this.normal.x * radiusB + pointB.x;
                float cBy = -this.normal.y * radiusB + pointB.y;
                this.points[0].x = (cAx + cBx) * 0.5f;
                this.points[0].y = (cAy + cBy) * 0.5f;
                break;
            }
            case FACE_A: {
                Vec2 planePoint = this.pool3;
                this.normal.x = xfA.R.col1.x * manifold.localNormal.x + xfA.R.col2.x * manifold.localNormal.y;
                this.normal.y = xfA.R.col1.y * manifold.localNormal.x + xfA.R.col2.y * manifold.localNormal.y;
                planePoint.x = xfA.position.x + xfA.R.col1.x * manifold.localPoint.x + xfA.R.col2.x * manifold.localPoint.y;
                planePoint.y = xfA.position.y + xfA.R.col1.y * manifold.localPoint.x + xfA.R.col2.y * manifold.localPoint.y;
                Vec2 clipPoint = this.pool4;
                for (int i = 0; i < manifold.pointCount; ++i) {
                    clipPoint.x = xfB.position.x + xfB.R.col1.x * manifold.points[i].localPoint.x + xfB.R.col2.x * manifold.points[i].localPoint.y;
                    clipPoint.y = xfB.position.y + xfB.R.col1.y * manifold.points[i].localPoint.x + xfB.R.col2.y * manifold.points[i].localPoint.y;
                    float scalar = radiusA - ((clipPoint.x - planePoint.x) * this.normal.x + (clipPoint.y - planePoint.y) * this.normal.y);
                    float cAx = this.normal.x * scalar + clipPoint.x;
                    float cAy = this.normal.y * scalar + clipPoint.y;
                    float cBx = -this.normal.x * radiusB + clipPoint.x;
                    float cBy = -this.normal.y * radiusB + clipPoint.y;
                    this.points[i].x = (cAx + cBx) * 0.5f;
                    this.points[i].y = (cAy + cBy) * 0.5f;
                }
                break;
            }
            case FACE_B: {
                Vec2 planePoint = this.pool3;
                Mat22 R = xfB.R;
                this.normal.x = R.col1.x * manifold.localNormal.x + R.col2.x * manifold.localNormal.y;
                this.normal.y = R.col1.y * manifold.localNormal.x + R.col2.y * manifold.localNormal.y;
                Vec2 v = manifold.localPoint;
                planePoint.x = xfB.position.x + xfB.R.col1.x * v.x + xfB.R.col2.x * v.y;
                planePoint.y = xfB.position.y + xfB.R.col1.y * v.x + xfB.R.col2.y * v.y;
                Vec2 clipPoint = this.pool4;
                for (int i = 0; i < manifold.pointCount; ++i) {
                    clipPoint.x = xfA.position.x + xfA.R.col1.x * manifold.points[i].localPoint.x + xfA.R.col2.x * manifold.points[i].localPoint.y;
                    clipPoint.y = xfA.position.y + xfA.R.col1.y * manifold.points[i].localPoint.x + xfA.R.col2.y * manifold.points[i].localPoint.y;
                    float scalar = radiusB - ((clipPoint.x - planePoint.x) * this.normal.x + (clipPoint.y - planePoint.y) * this.normal.y);
                    float cBx = this.normal.x * scalar + clipPoint.x;
                    float cBy = this.normal.y * scalar + clipPoint.y;
                    float cAx = -this.normal.x * radiusA + clipPoint.x;
                    float cAy = -this.normal.y * radiusA + clipPoint.y;
                    this.points[i].x = (cAx + cBx) * 0.5f;
                    this.points[i].y = (cAy + cBy) * 0.5f;
                }
                this.normal.x = -this.normal.x;
                this.normal.y = -this.normal.y;
            }
        }
    }
}

