/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import java.io.Serializable;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.Vec3;

public class Mat33
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Mat33 IDENTITY = new Mat33(new Vec3(1.0f, 0.0f, 0.0f), new Vec3(0.0f, 1.0f, 0.0f), new Vec3(0.0f, 0.0f, 1.0f));
    public final Vec3 col1;
    public final Vec3 col2;
    public final Vec3 col3;

    public Mat33() {
        this.col1 = new Vec3();
        this.col2 = new Vec3();
        this.col3 = new Vec3();
    }

    public Mat33(Vec3 argCol1, Vec3 argCol2, Vec3 argCol3) {
        this.col1 = argCol1.clone();
        this.col2 = argCol2.clone();
        this.col3 = argCol3.clone();
    }

    public void setZero() {
        this.col1.setZero();
        this.col2.setZero();
        this.col3.setZero();
    }

    public static final Vec3 mul(Mat33 A, Vec3 v) {
        return new Vec3(v.x * A.col1.x + v.y * A.col2.x + v.z + A.col3.x, v.x * A.col1.y + v.y * A.col2.y + v.z * A.col3.y, v.x * A.col1.z + v.y * A.col2.z + v.z * A.col3.z);
    }

    public static final void mulToOut(Mat33 A, Vec3 v, Vec3 out) {
        float tempy = v.x * A.col1.y + v.y * A.col2.y + v.z * A.col3.y;
        float tempz = v.x * A.col1.z + v.y * A.col2.z + v.z * A.col3.z;
        out.x = v.x * A.col1.x + v.y * A.col2.x + v.z + A.col3.x;
        out.y = tempy;
        out.z = tempz;
    }

    public final Vec2 solve22(Vec2 b) {
        Vec2 x = new Vec2();
        this.solve22ToOut(b, x);
        return x;
    }

    public final void solve22ToOut(Vec2 b, Vec2 out) {
        float a11 = this.col1.x;
        float a22 = this.col2.y;
        float a12 = this.col2.x;
        float a21 = this.col1.y;
        float det = a11 * a22 - a12 * a21;
        if (det != 0.0f) {
            det = 1.0f / det;
        }
        out.x = det * (a22 * b.x - a12 * b.y);
        out.y = det * (a11 * b.y - a21 * b.x);
    }

    public final Vec3 solve33(Vec3 b) {
        Vec3 x = new Vec3();
        this.solve33ToOut(b, x);
        return x;
    }

    public final void solve33ToOut(Vec3 b, Vec3 out) {
        Vec3.crossToOut(this.col2, this.col3, out);
        float det = Vec3.dot(this.col1, out);
        if (det != 0.0f) {
            det = 1.0f / det;
        }
        Vec3.crossToOut(this.col2, this.col3, out);
        float x = det * Vec3.dot(b, out);
        Vec3.crossToOut(b, this.col3, out);
        float y = det * Vec3.dot(this.col1, out);
        Vec3.crossToOut(this.col2, b, out);
        float z = det * Vec3.dot(this.col1, out);
        out.x = x;
        out.y = y;
        out.z = z;
    }
}

