/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.serialization.pb;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.box2d.proto.Box2D;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.joints.ConstantVolumeJointDef;
import org.jbox2d.dynamics.joints.DistanceJoint;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.FrictionJointDef;
import org.jbox2d.dynamics.joints.GearJointDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.LineJointDef;
import org.jbox2d.dynamics.joints.MouseJointDef;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.dynamics.joints.PulleyJointDef;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.dynamics.joints.WeldJointDef;
import org.jbox2d.serialization.JbDeserializer;
import org.jbox2d.serialization.UnsupportedListener;
import org.jbox2d.serialization.UnsupportedObjectException;

public class PbDeserializer
implements JbDeserializer {
    private JbDeserializer.ObjectListener listener = null;
    private UnsupportedListener ulistener = null;

    public PbDeserializer() {
    }

    public PbDeserializer(UnsupportedListener argListener) {
        this.ulistener = argListener;
    }

    public PbDeserializer(JbDeserializer.ObjectListener argObjectListner) {
        this.listener = argObjectListner;
    }

    public PbDeserializer(UnsupportedListener argListener, JbDeserializer.ObjectListener argObjectListner) {
        this.ulistener = argListener;
        this.listener = argObjectListner;
    }

    @Override
    public void setObjectListener(JbDeserializer.ObjectListener argListener) {
        this.listener = argListener;
    }

    @Override
    public void setUnsupportedListener(UnsupportedListener argListener) {
        this.ulistener = argListener;
    }

    private boolean isIndependentJoint(Box2D.PbJointType argType) {
        return argType != Box2D.PbJointType.GEAR && argType != Box2D.PbJointType.CONSTANT_VOLUME;
    }

    @Override
    public World deserializeWorld(InputStream argInput) throws IOException {
        Box2D.PbWorld world = Box2D.PbWorld.parseFrom(argInput);
        return this.deserializeWorld(world);
    }

    public World deserializeWorld(Box2D.PbWorld argWorld) {
        Joint joint;
        Box2D.PbJoint pbJoint;
        int i;
        World world = new World(this.pbToVec(argWorld.getGravity()), argWorld.getAllowSleep());
        world.setAutoClearForces(argWorld.getAutoClearForces());
        world.setContinuousPhysics(argWorld.getContinuousPhysics());
        world.setWarmStarting(argWorld.getWarmStarting());
        HashMap<Integer, Body> bodyMap = new HashMap<Integer, Body>();
        HashMap<Integer, Joint> jointMap = new HashMap<Integer, Joint>();
        for (int i2 = 0; i2 < argWorld.getBodiesCount(); ++i2) {
            Box2D.PbBody pbBody = argWorld.getBodies(i2);
            Body body = this.deserializeBody(world, pbBody);
            bodyMap.put(i2, body);
        }
        int cnt = 0;
        for (i = 0; i < argWorld.getJointsCount(); ++i) {
            pbJoint = argWorld.getJoints(i);
            if (!this.isIndependentJoint(pbJoint.getType())) continue;
            joint = this.deserializeJoint(world, pbJoint, bodyMap, jointMap);
            jointMap.put(cnt, joint);
            ++cnt;
        }
        for (i = 0; i < argWorld.getJointsCount(); ++i) {
            pbJoint = argWorld.getJoints(i);
            if (this.isIndependentJoint(pbJoint.getType())) continue;
            joint = this.deserializeJoint(world, pbJoint, bodyMap, jointMap);
            jointMap.put(cnt, joint);
            ++cnt;
        }
        if (this.listener != null && argWorld.hasTag()) {
            this.listener.processWorld(world, argWorld.getTag());
        }
        return world;
    }

    @Override
    public Body deserializeBody(World argWorld, InputStream argInput) throws IOException {
        Box2D.PbBody body = Box2D.PbBody.parseFrom(argInput);
        return this.deserializeBody(argWorld, body);
    }

    public Body deserializeBody(World argWorld, Box2D.PbBody argBody) {
        Box2D.PbBody b = argBody;
        BodyDef bd = new BodyDef();
        bd.active = b.getActive();
        bd.allowSleep = b.getAllowSleep();
        bd.angle = b.getAngle();
        bd.angularDamping = b.getAngularDamping();
        bd.angularVelocity = b.getAngularVelocity();
        bd.awake = b.getAwake();
        bd.bullet = b.getBullet();
        bd.fixedRotation = b.getFixedRotation();
        bd.linearDamping = b.getLinearDamping();
        bd.linearVelocity.set(this.pbToVec(b.getLinearVelocity()));
        bd.position.set(this.pbToVec(b.getPosition()));
        switch (b.getType()) {
            case DYNAMIC: {
                bd.type = BodyType.DYNAMIC;
                break;
            }
            case KINEMATIC: {
                bd.type = BodyType.KINEMATIC;
                break;
            }
            case STATIC: {
                bd.type = BodyType.STATIC;
                break;
            }
            default: {
                UnsupportedObjectException e = new UnsupportedObjectException("Unknown body type: " + argBody.getType(), UnsupportedObjectException.Type.BODY);
                if (this.ulistener == null || this.ulistener.isUnsupported(e)) {
                    throw e;
                }
                return null;
            }
        }
        Body body = argWorld.createBody(bd);
        for (int i = 0; i < b.getFixturesCount(); ++i) {
            this.deserializeFixture(body, b.getFixtures(i));
        }
        if (this.listener != null && b.hasTag()) {
            this.listener.processBody(body, b.getTag());
        }
        return body;
    }

    @Override
    public Fixture deserializeFixture(Body argBody, InputStream argInput) throws IOException {
        Box2D.PbFixture fixture = Box2D.PbFixture.parseFrom(argInput);
        return this.deserializeFixture(argBody, fixture);
    }

    public Fixture deserializeFixture(Body argBody, Box2D.PbFixture argFixture) {
        Box2D.PbFixture f = argFixture;
        FixtureDef fd = new FixtureDef();
        fd.density = f.getDensity();
        fd.filter.categoryBits = f.getFilter().getCategoryBits();
        fd.filter.groupIndex = f.getFilter().getGroupIndex();
        fd.filter.maskBits = f.getFilter().getMaskBits();
        fd.friction = f.getFriction();
        fd.isSensor = f.getSensor();
        fd.restitution = f.getRestitution();
        fd.shape = this.deserializeShape(f.getShape());
        Fixture fixture = argBody.createFixture(fd);
        if (this.listener != null) {
            this.listener.processFixture(fixture, f.getTag());
        }
        return fixture;
    }

    @Override
    public Shape deserializeShape(InputStream argInput) throws IOException {
        Box2D.PbShape s = Box2D.PbShape.parseFrom(argInput);
        return this.deserializeShape(s);
    }

    public Shape deserializeShape(Box2D.PbShape argShape) {
        Box2D.PbShape s = argShape;
        Shape shape = null;
        switch (s.getType()) {
            case CIRCLE: {
                CircleShape c = new CircleShape();
                c.m_p.set(this.pbToVec(s.getCenter()));
                c.m_radius = s.getRadius();
                shape = c;
                break;
            }
            case POLYGON: {
                PolygonShape p = new PolygonShape();
                p.m_centroid.set(this.pbToVec(s.getCentroid()));
                p.m_radius = s.getRadius();
                p.m_vertexCount = s.getPointsCount();
                for (int i = 0; i < p.m_vertexCount; ++i) {
                    p.m_vertices[i].set(this.pbToVec(s.getPoints(i)));
                    p.m_normals[i].set(this.pbToVec(s.getNormals(i)));
                }
                shape = p;
                break;
            }
            case EDGE: 
            case LOOP: {
                UnsupportedObjectException e = new UnsupportedObjectException("Edge and loop shapes are not yet supported", UnsupportedObjectException.Type.SHAPE);
                if (this.ulistener == null || this.ulistener.isUnsupported(e)) {
                    throw e;
                }
                return null;
            }
            default: {
                UnsupportedObjectException e = new UnsupportedObjectException("Unknown shape type: " + s.getType(), UnsupportedObjectException.Type.SHAPE);
                if (this.ulistener == null || this.ulistener.isUnsupported(e)) {
                    throw e;
                }
                return null;
            }
        }
        if (this.listener != null) {
            this.listener.processShape(shape, s.getTag());
        }
        return shape;
    }

    @Override
    public Joint deserializeJoint(World argWorld, InputStream argInput, Map<Integer, Body> argBodyMap, Map<Integer, Joint> argJointMap) throws IOException {
        Box2D.PbJoint joint = Box2D.PbJoint.parseFrom(argInput);
        return this.deserializeJoint(argWorld, joint, argBodyMap, argJointMap);
    }

    public Joint deserializeJoint(World argWorld, Box2D.PbJoint argJoint, Map<Integer, Body> argBodyMap, Map<Integer, Joint> argJointMap) {
        JointDef jd = null;
        switch (argJoint.getType()) {
            case PRISMATIC: {
                JointDef def;
                jd = def = new PrismaticJointDef();
                ((PrismaticJointDef)def).enableLimit = argJoint.getEnableLimit();
                ((PrismaticJointDef)def).enableMotor = argJoint.getEnableMotor();
                ((PrismaticJointDef)def).localAnchorA.set(this.pbToVec(argJoint.getLocalAnchorA()));
                ((PrismaticJointDef)def).localAnchorB.set(this.pbToVec(argJoint.getLocalAnchorB()));
                ((PrismaticJointDef)def).localAxis1.set(this.pbToVec(argJoint.getLocalAxisA()));
                ((PrismaticJointDef)def).lowerTranslation = argJoint.getLowerLimit();
                ((PrismaticJointDef)def).maxMotorForce = argJoint.getMaxMotorForce();
                ((PrismaticJointDef)def).motorSpeed = argJoint.getMotorSpeed();
                ((PrismaticJointDef)def).referenceAngle = argJoint.getRefAngle();
                ((PrismaticJointDef)def).upperTranslation = argJoint.getUpperLimit();
                break;
            }
            case REVOLUTE: {
                JointDef def;
                jd = def = new RevoluteJointDef();
                ((RevoluteJointDef)def).enableLimit = argJoint.getEnableLimit();
                ((RevoluteJointDef)def).enableMotor = argJoint.getEnableMotor();
                ((RevoluteJointDef)def).localAnchorA.set(this.pbToVec(argJoint.getLocalAnchorA()));
                ((RevoluteJointDef)def).localAnchorB.set(this.pbToVec(argJoint.getLocalAnchorB()));
                ((RevoluteJointDef)def).lowerAngle = argJoint.getLowerLimit();
                ((RevoluteJointDef)def).maxMotorTorque = argJoint.getMaxMotorTorque();
                ((RevoluteJointDef)def).motorSpeed = argJoint.getMotorSpeed();
                ((RevoluteJointDef)def).referenceAngle = argJoint.getRefAngle();
                ((RevoluteJointDef)def).upperAngle = argJoint.getUpperLimit();
                break;
            }
            case DISTANCE: {
                JointDef def;
                jd = def = new DistanceJointDef();
                ((DistanceJointDef)def).localAnchorA.set(this.pbToVec(argJoint.getLocalAnchorA()));
                ((DistanceJointDef)def).localAnchorB.set(this.pbToVec(argJoint.getLocalAnchorB()));
                ((DistanceJointDef)def).dampingRatio = argJoint.getDampingRatio();
                ((DistanceJointDef)def).frequencyHz = argJoint.getFrequency();
                ((DistanceJointDef)def).length = argJoint.getLength();
                break;
            }
            case PULLEY: {
                JointDef def;
                jd = def = new PulleyJointDef();
                ((PulleyJointDef)def).localAnchorA.set(this.pbToVec(argJoint.getLocalAnchorA()));
                ((PulleyJointDef)def).localAnchorB.set(this.pbToVec(argJoint.getLocalAnchorB()));
                ((PulleyJointDef)def).groundAnchorA.set(this.pbToVec(argJoint.getGroundAnchorA()));
                ((PulleyJointDef)def).groundAnchorB.set(this.pbToVec(argJoint.getGroundAnchorB()));
                ((PulleyJointDef)def).lengthA = argJoint.getLengthA();
                ((PulleyJointDef)def).lengthB = argJoint.getLengthB();
                ((PulleyJointDef)def).maxLengthA = argJoint.getMaxLengthA();
                ((PulleyJointDef)def).maxLengthB = argJoint.getMaxLengthB();
                ((PulleyJointDef)def).ratio = argJoint.getRatio();
                break;
            }
            case MOUSE: {
                JointDef def;
                jd = def = new MouseJointDef();
                ((MouseJointDef)def).dampingRatio = argJoint.getDampingRatio();
                ((MouseJointDef)def).frequencyHz = argJoint.getFrequency();
                ((MouseJointDef)def).maxForce = argJoint.getMaxForce();
                ((MouseJointDef)def).target.set(this.pbToVec(argJoint.getTarget()));
                break;
            }
            case GEAR: {
                JointDef def;
                jd = def = new GearJointDef();
                if (!argJointMap.containsKey(argJoint.getJoint1())) {
                    throw new IllegalArgumentException("Index " + argJoint.getJoint1() + " is not present in the joint map.");
                }
                ((GearJointDef)def).joint1 = argJointMap.get(argJoint.getJoint1());
                if (!argJointMap.containsKey(argJoint.getJoint2())) {
                    throw new IllegalArgumentException("Index " + argJoint.getJoint2() + " is not present in the joint map.");
                }
                ((GearJointDef)def).joint2 = argJointMap.get(argJoint.getJoint2());
                ((GearJointDef)def).ratio = argJoint.getRatio();
                break;
            }
            case WHEEL: {
                UnsupportedObjectException e = new UnsupportedObjectException("Wheel joint not supported yet.", UnsupportedObjectException.Type.JOINT);
                if (this.ulistener == null || this.ulistener.isUnsupported(e)) {
                    throw e;
                }
                return null;
            }
            case WELD: {
                JointDef def;
                jd = def = new WeldJointDef();
                ((WeldJointDef)def).localAnchorA.set(this.pbToVec(argJoint.getLocalAnchorA()));
                ((WeldJointDef)def).localAnchorB.set(this.pbToVec(argJoint.getLocalAnchorB()));
                ((WeldJointDef)def).referenceAngle = argJoint.getRefAngle();
                break;
            }
            case FRICTION: {
                JointDef def;
                jd = def = new FrictionJointDef();
                ((FrictionJointDef)def).localAnchorA.set(this.pbToVec(argJoint.getLocalAnchorA()));
                ((FrictionJointDef)def).localAnchorB.set(this.pbToVec(argJoint.getLocalAnchorB()));
                ((FrictionJointDef)def).maxForce = argJoint.getMaxForce();
                ((FrictionJointDef)def).maxTorque = argJoint.getMaxTorque();
                break;
            }
            case ROPE: {
                UnsupportedObjectException e = new UnsupportedObjectException("Rope joint not supported yet.", UnsupportedObjectException.Type.JOINT);
                if (this.ulistener == null || this.ulistener.isUnsupported(e)) {
                    throw e;
                }
                return null;
            }
            case CONSTANT_VOLUME: {
                JointDef def;
                jd = def = new ConstantVolumeJointDef();
                ((ConstantVolumeJointDef)def).dampingRatio = argJoint.getDampingRatio();
                ((ConstantVolumeJointDef)def).frequencyHz = argJoint.getFrequency();
                if (argJoint.getBodiesCount() != argJoint.getJointsCount()) {
                    throw new IllegalArgumentException("Constant volume joint must have bodies and joints defined");
                }
                for (int i = 0; i < argJoint.getBodiesCount(); ++i) {
                    int body = argJoint.getBodies(i);
                    if (!argBodyMap.containsKey(body)) {
                        throw new IllegalArgumentException("Index " + body + " is not present in the body map");
                    }
                    int joint = argJoint.getJoints(i);
                    if (!argJointMap.containsKey(joint)) {
                        throw new IllegalArgumentException("Index " + joint + " is not present in the joint map");
                    }
                    Joint djoint = argJointMap.get(joint);
                    if (!(djoint instanceof DistanceJoint)) {
                        throw new IllegalArgumentException("Joints for constant volume joint must be distance joints");
                    }
                    ((ConstantVolumeJointDef)def).addBodyAndJoint(argBodyMap.get(body), (DistanceJoint)djoint);
                }
                break;
            }
            case LINE: {
                JointDef def;
                jd = def = new LineJointDef();
                ((LineJointDef)def).localAnchorA.set(this.pbToVec(argJoint.getLocalAnchorA()));
                ((LineJointDef)def).localAnchorB.set(this.pbToVec(argJoint.getLocalAnchorB()));
                ((LineJointDef)def).localAxisA.set(this.pbToVec(argJoint.getLocalAxisA()));
                ((LineJointDef)def).enableLimit = argJoint.getEnableLimit();
                ((LineJointDef)def).enableMotor = argJoint.getEnableMotor();
                ((LineJointDef)def).lowerTranslation = argJoint.getLowerLimit();
                ((LineJointDef)def).upperTranslation = argJoint.getUpperLimit();
                ((LineJointDef)def).maxMotorForce = argJoint.getMaxForce();
                ((LineJointDef)def).motorSpeed = argJoint.getMotorSpeed();
                break;
            }
            default: {
                UnsupportedObjectException e = new UnsupportedObjectException("Unknown joint type: " + argJoint.getType(), UnsupportedObjectException.Type.JOINT);
                if (this.ulistener == null || this.ulistener.isUnsupported(e)) {
                    throw e;
                }
                return null;
            }
        }
        jd.collideConnected = argJoint.getCollideConnected();
        if (!argBodyMap.containsKey(argJoint.getBodyA())) {
            throw new IllegalArgumentException("Index " + argJoint.getBodyA() + " is not present in the body map");
        }
        jd.bodyA = argBodyMap.get(argJoint.getBodyA());
        if (!argBodyMap.containsKey(argJoint.getBodyB())) {
            throw new IllegalArgumentException("Index " + argJoint.getBodyB() + " is not present in the body map");
        }
        jd.bodyB = argBodyMap.get(argJoint.getBodyB());
        Joint joint = argWorld.createJoint(jd);
        if (this.listener != null && argJoint.hasTag()) {
            this.listener.processJoint(joint, argJoint.getTag());
        }
        return joint;
    }

    private Vec2 pbToVec(Box2D.PbVec2 argVec) {
        return new Vec2(argVec.getX(), argVec.getY());
    }
}

