/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.joints.FrictionJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class ApplyForce
extends TestbedTest {
    private static final long BODY_TAG = 1L;
    Body m_body;

    @Override
    public void initTest(boolean argDeserialized) {
        if (argDeserialized) {
            return;
        }
        this.getWorld().setGravity(new Vec2(0.0f, 0.0f));
        float k_restitution = 0.4f;
        BodyDef bd = new BodyDef();
        bd.position.set(0.0f, 20.0f);
        Body ground = this.getWorld().createBody(bd);
        PolygonShape shape = new PolygonShape();
        FixtureDef sd = new FixtureDef();
        sd.shape = shape;
        sd.density = 0.0f;
        sd.restitution = 0.4f;
        shape.setAsEdge(new Vec2(-20.0f, -20.0f), new Vec2(-20.0f, 20.0f));
        ground.createFixture(sd);
        shape.setAsEdge(new Vec2(20.0f, -20.0f), new Vec2(20.0f, 20.0f));
        ground.createFixture(sd);
        shape.setAsEdge(new Vec2(-20.0f, 20.0f), new Vec2(20.0f, 20.0f));
        ground.createFixture(sd);
        shape.setAsEdge(new Vec2(-20.0f, -20.0f), new Vec2(20.0f, -20.0f));
        ground.createFixture(sd);
        Transform xf1 = new Transform();
        xf1.R.set(1.1070973f);
        Mat22.mulToOut(xf1.R, new Vec2(1.0f, 0.0f), xf1.position);
        Vec2[] vertices = new Vec2[]{Transform.mul(xf1, new Vec2(-1.0f, 0.0f)), Transform.mul(xf1, new Vec2(1.0f, 0.0f)), Transform.mul(xf1, new Vec2(0.0f, 0.5f))};
        PolygonShape poly1 = new PolygonShape();
        poly1.set(vertices, 3);
        FixtureDef sd1 = new FixtureDef();
        sd1.shape = poly1;
        sd1.density = 4.0f;
        Transform xf2 = new Transform();
        xf2.R.set(-1.1070973f);
        Mat22.mulToOut(xf2.R, new Vec2(-1.0f, 0.0f), xf2.position);
        vertices[0] = Transform.mul(xf2, new Vec2(-1.0f, 0.0f));
        vertices[1] = Transform.mul(xf2, new Vec2(1.0f, 0.0f));
        vertices[2] = Transform.mul(xf2, new Vec2(0.0f, 0.5f));
        PolygonShape poly2 = new PolygonShape();
        poly2.set(vertices, 3);
        FixtureDef sd2 = new FixtureDef();
        sd2.shape = poly2;
        sd2.density = 2.0f;
        BodyDef bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        bd2.angularDamping = 5.0f;
        bd2.linearDamping = 0.1f;
        bd2.position.set(0.0f, 2.0f);
        bd2.angle = (float)Math.PI;
        bd2.allowSleep = false;
        this.m_body = this.getWorld().createBody(bd2);
        this.m_body.createFixture(sd1);
        this.m_body.createFixture(sd2);
        PolygonShape shape2 = new PolygonShape();
        shape2.setAsBox(0.5f, 0.5f);
        FixtureDef fd = new FixtureDef();
        fd.shape = shape2;
        fd.density = 1.0f;
        fd.friction = 0.3f;
        for (int i = 0; i < 10; ++i) {
            BodyDef bd3 = new BodyDef();
            bd3.type = BodyType.DYNAMIC;
            bd3.position.set(0.0f, 5.0f + 1.54f * (float)i);
            Body body = this.getWorld().createBody(bd3);
            body.createFixture(fd);
            float gravity = 10.0f;
            float I = body.getInertia();
            float mass = body.getMass();
            float radius = MathUtils.sqrt(2.0f * I / mass);
            FrictionJointDef jd = new FrictionJointDef();
            jd.localAnchorA.setZero();
            jd.localAnchorB.setZero();
            jd.bodyA = ground;
            jd.bodyB = body;
            jd.collideConnected = true;
            jd.maxForce = mass * gravity;
            jd.maxTorque = mass * radius * gravity;
            this.getWorld().createJoint(jd);
        }
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("Use 'wasd' to move, 'e' and 's' drift.");
        if (this.getModel().getKeys()[119]) {
            Vec2 f = this.m_body.getWorldVector(new Vec2(0.0f, -30.0f));
            Vec2 p = this.m_body.getWorldPoint(this.m_body.getLocalCenter().add(new Vec2(0.0f, 2.0f)));
            this.m_body.applyForce(f, p);
        } else if (this.getModel().getKeys()[113]) {
            Vec2 f = this.m_body.getWorldVector(new Vec2(0.0f, -30.0f));
            Vec2 p = this.m_body.getWorldPoint(this.m_body.getLocalCenter().add(new Vec2(-0.2f, 0.0f)));
            this.m_body.applyForce(f, p);
        } else if (this.getModel().getKeys()[101]) {
            Vec2 f = this.m_body.getWorldVector(new Vec2(0.0f, -30.0f));
            Vec2 p = this.m_body.getWorldPoint(this.m_body.getLocalCenter().add(new Vec2(0.2f, 0.0f)));
            this.m_body.applyForce(f, p);
        } else if (this.getModel().getKeys()[115]) {
            Vec2 f = this.m_body.getWorldVector(new Vec2(0.0f, 30.0f));
            Vec2 p = this.m_body.getWorldCenter();
            this.m_body.applyForce(f, p);
        }
        if (this.getModel().getKeys()[97]) {
            this.m_body.applyTorque(20.0f);
        }
        if (this.getModel().getKeys()[100]) {
            this.m_body.applyTorque(-20.0f);
        }
    }

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public Long getTag(Body argBody) {
        if (argBody == this.m_body) {
            return 1L;
        }
        return null;
    }

    @Override
    public void processBody(Body argBody, Long argTag) {
        if (argTag == 1L) {
            this.m_body = argBody;
        }
    }

    @Override
    public String getTestName() {
        return "Apply Force";
    }
}

