/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.callbacks.ContactImpulse;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class Breakable
extends TestbedTest {
    Body m_body1;
    Vec2 m_velocity;
    float m_angularVelocity;
    PolygonShape m_shape1;
    PolygonShape m_shape2;
    Fixture m_piece1;
    Fixture m_piece2;
    boolean m_broke;
    boolean m_break;

    @Override
    public void initTest(boolean argDeserialized) {
        BodyDef bd = new BodyDef();
        Body ground = this.getWorld().createBody(bd);
        PolygonShape shape = new PolygonShape();
        shape.setAsEdge(new Vec2(-40.0f, 0.0f), new Vec2(40.0f, 0.0f));
        ground.createFixture(shape, 0.0f);
        bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        bd.position.set(0.0f, 40.0f);
        bd.angle = 0.7853982f;
        this.m_body1 = this.getWorld().createBody(bd);
        this.m_shape1 = new PolygonShape();
        this.m_shape1.setAsBox(0.5f, 0.5f, new Vec2(-0.5f, 0.0f), 0.0f);
        this.m_piece1 = this.m_body1.createFixture(this.m_shape1, 1.0f);
        this.m_shape2 = new PolygonShape();
        this.m_shape2.setAsBox(0.5f, 0.5f, new Vec2(0.5f, 0.0f), 0.0f);
        this.m_piece2 = this.m_body1.createFixture(this.m_shape2, 1.0f);
        this.m_break = false;
        this.m_broke = false;
    }

    @Override
    public void postSolve(Contact contact, ContactImpulse impulse) {
        if (this.m_broke) {
            return;
        }
        int count = contact.getManifold().pointCount;
        float maxImpulse = 0.0f;
        for (int i = 0; i < count; ++i) {
            maxImpulse = MathUtils.max(maxImpulse, impulse.normalImpulses[i]);
        }
        if (maxImpulse > 40.0f) {
            this.m_break = true;
        }
    }

    void Break() {
        Body body1 = this.m_piece1.getBody();
        Vec2 center = body1.getWorldCenter();
        body1.destroyFixture(this.m_piece2);
        this.m_piece2 = null;
        BodyDef bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        bd.position = body1.getPosition();
        bd.angle = body1.getAngle();
        Body body2 = this.getWorld().createBody(bd);
        this.m_piece2 = body2.createFixture(this.m_shape2, 1.0f);
        Vec2 center1 = body1.getWorldCenter();
        Vec2 center2 = body2.getWorldCenter();
        Vec2 velocity1 = this.m_velocity.add(Vec2.cross(this.m_angularVelocity, center1.sub(center)));
        Vec2 velocity2 = this.m_velocity.add(Vec2.cross(this.m_angularVelocity, center2.sub(center)));
        body1.setAngularVelocity(this.m_angularVelocity);
        body1.setLinearVelocity(velocity1);
        body2.setAngularVelocity(this.m_angularVelocity);
        body2.setLinearVelocity(velocity2);
    }

    @Override
    public void step(TestbedSettings settings) {
        if (this.m_break) {
            this.Break();
            this.m_broke = true;
            this.m_break = false;
        }
        if (!this.m_broke) {
            this.m_velocity = this.m_body1.getLinearVelocity();
            this.m_angularVelocity = this.m_body1.getAngularVelocity();
        }
        super.step(settings);
    }

    @Override
    public String getTestName() {
        return "Breakable";
    }
}

